[org 100h]
[section .data]
putpxlmethod dw PUTPIXEL19
[section .bss]
x1 resw 01h
x2 resw 01h
y1 resw 01h
y2 resw 01h
linecolor resb 01h

W1 resw 01h
W2 resw 01h
W3 resw 01h

row resw 01h
column resw 01h

[section .text]
call RPSEED

          mov   ax,0013h
          int   10h
          mov   ax,0A000h
          mov   es,ax

nextrand:
;call DELAY
;call QDELAY
;call VERTRETRACEWAIT

call RPRAND
rpr1:
cmp ax,319
jc okcol
sub ax,320
jmp rpr1
okcol:
mov [x1],ax

call RPRAND
rpr11:
cmp ax,319
jc okcol2
sub ax,320
jmp rpr11
okcol2:
mov [x2],ax

call RPRAND
rpr2:
cmp ax,199
jc okrow
sub ax,200
jmp rpr2
okrow:
mov [y1],ax

call RPRAND
rpr21:
cmp ax,199
jc okrow2
sub ax,200
jmp rpr21
okrow2:
mov [y2],ax

call RPRAND
mov [linecolor],al

call JRLINE
mov ah,01h
int 016h
jnz blur
jmp nextrand

blur:
xor ax,ax
int 16h              ; eat the key

;-------------------------------[ Problem Code Below ]

                                    ;This is the bit which
                mov cx,160          ;relates to my problem.
loopall:
;call QDELAY
                mov bx,64000        ;Although this is very
blurscreen:                         ;simple and only uses
          mov     dl,[es:bx+1]     ;a few fast instructions
          mov     al,[es:bx-320]   ;the time it takes to
          add     dx,ax             ;blur the whole screen
          mov     al,[es:bx+320]   ;seems to be far longer
          add     dx,ax             ;than the time available
          mov     al,[es:bx-1]     ;for creating fast and
          add     dx,ax             ;smooth effects.
          shr     dx,2
          mov     [es:bx],dl       ;Instead of making a
                                    ;nice steady animation,
          dec bx                    ;there is flicker and
          jnz blurscreen            ;the actual drawing can
          loop loopall              ;be seen being done as
                                    ;it travels up the screen


;-------------------------------[ Problem Code Above ]

      mov   ax,03
      int   10h
      mov   ax,4c00h
      int   21h


;------------------------------------------
RPSEED
xor ax,ax
int 01Ah
mov [W1],dx
mov ah,02h
int 01Ah
mov [W2],cx
mov [W3],dx
ret
;----------------------------------------------

;----------------------------------------------
RPRAND

mov     ax,[W1]       ;get current word values...
mov     bx,[W2]
mov     cx,[W3]

xor     ax,bx       ;exclusive or W1 with W2
ror     ax,cl       ;rotate W1 (per low nibble of W3)
adc     bx,cx       ;add W3 to W2 (+ random carry)
xor     cx,ax       ;exclusive or W3 with new W1

mov     [W1],ax       ;store new word values...
mov     [W2],bx
mov     [W3],cx
ret
;----------------------------------------------------

;--------------------------------------------
PUTPIXEL19
push ax
push cx
push dx
push di

push ax
mov ax,320
mul dx
add ax,cx
mov di,ax
pop ax
mov [es:di],al
pop di
pop dx
pop cx
pop ax
ret
;-------------------------------------------

;-------------------------------------------
DELAY
    push ax
    push bx
    push ds

    mov ax,040h
    mov ds,ax
    mov bx,[06Ch]
delay1:
    mov ax,[06Ch]
    cmp ax,bx
    jz delay1
    mov bx,ax
delay2:
    mov ax,[06Ch]
    cmp ax,bx
    jz delay2

    pop ds
    pop bx
    pop ax
    ret
;------------------------------------------------------------


;----------------------------------------------------
VERTRETRACEWAIT
    push ax
    push dx

     mov      dx,03dah            ; prepare refresh register
vrw1:
     in       al,dx               ; wait for current retrace to end
     test     al,08h
     jnz      vrw1
vrw2:
     in       al,dx               ; wait for current screen trace to end
     test     al,08h
     jz       vrw2

     pop dx
     pop ax
     ret
;------------------------------------------------------

;-----------------------------------------------------
QDELAY
    push ax
    push cx
    push dx

    mov cx,00h
    mov dx,01h
    mov ah,086h
    int 015h

     pop dx
     pop cx
     pop ax
     ret
;------------------------------------------------------

;--------------------------------------
;Author: John Ribera
;Date:   10-21-85
;Purpose: Draw a line calling a function
;         for each point.
;www.mindspring.com/~kilroy
;jjr@dcm.net
;
;--------------------------------------
JRLINE
                mov             cx,[x1]
                mov             si,[x2]
                mov             dx,[y1]
                mov             di,[y2]
X2_X1:  MOV		AX, CX
        SUB		AX, SI		;ax = x2-x1
        MOV		CH, 49H		;ASSUME INC CX
        JNC		Y2_Y1
        MOV		CH, 41H		;GONNA BE DEC CX
        NEG		AX			;ax = abs(x2-x1)
Y2_Y1:  MOV		BX,DX		;bx = y2-y1
        SUB		BX,DI
        MOV		CL,4AH		;ASSUME DEC DX
        JNC		CMP_XY
        MOV		CL,42H		;GONNA BE INC DX
        NEG		BX			;bx = abs(y2-y1)
CMP_XY: CMP		AX,BX
        JG		dxGTdy		;if (dx > dy)
        XCHG	AX,BX		;  xchg dx <-> dy
        XCHG	CL,CH		;  xchg rise <-> run
dxGTdy: MOV		SI,BX		;si = min(dx, dy)
        MOV		DI,AX		;di = ax = max(dx, dy)
	cmp		ax, 0
        jz              exitjrl
        MOV             WORD[CS:RISE],CX
INITLP: mov             cx,[x1]       ;RESTORE X2 (starting point)
        XOR		BX,BX		;bx is numerator
nextpt: ADD		BX,SI		;bx += min(dx, dy)
        CMP		BX,DI		;if (bx > max(dx, dy))
        JL		RUN			;  bx -= max(dx, dy)
        SUB		BX,DI
RISE:   INC		CX
RUN:    INC		DX          ;ALWAYS RUN ONCE
     push ax
     mov al,[linecolor]
     call    word[putpxlmethod]       ;PUTPIXEL17
     pop ax
        DEC		AX
        JNZ		nextpt
exitjrl:
        RET
;--------------------------------------------------------
