org 0100h

segment .data

  vidseg dw 0B800h

  aboxx1 db 05h          ; starting column
  aboxx2 db 04Ah         ; ending column
  aboxy1 db 05h          ; starting row
  aboxy2 db 0Ah          ; ending row

  aboxc1 db 03Bh         ; color for left and top sides
  aboxc2 db 030h         ; color for right and bottom sides

  aboxlt db 0DAh         ; left top corner box character
  aboxrt db 0BFh         ; right top        "
  aboxlb db 0C0h         ; left bottom
  aboxrb db 0D9h         ; right bottom
  aboxhor db 0C4h        ; top and bottom line
  aboxver db 0B3h        ; sides
  aboxblank db 020h      ; center "fill" character

                ; message format: col,row,color,text,zero
  press db   01Eh,0Fh,030h,'   Press to Test   ',00h
  release db 01Eh,0Fh,030h,'Release to Detonate',00h
  msg1 db 022h,00h,01Dh,'  Colors!  ',00h
  msg2 db 045h,00h,084h,' Blinking! ',00h
  msg3 db 00h,018h,08Eh,' Cosmic! ',00h
  msg4 db 043h,018h,07h,' Plain text. ',00h
  msg5 db 00h,00h,070h,' Inverse Text ',00h
  msg6 db 022h,018h,060h,'Esc to quit',00h

     ; column, row, char,attrib,char,attrib.... format
  amsg1 db 020h,0Ah,' ',07h,'H',01h,'e',02h,'l',03h,'l',04h
      db 'o',05h,',',06h,' ',07h
      db 'W',0dh,'o',0eh,'r',09h,'l',0ah,'d',0bh,'!',0ch,' ',07h,00h

segment .text

  mov ax,060C5h               ; black-on-red, "cross" box character
  call ACLS                   ; gives sort of a "brick wall" effect
;  mov ax,03B2h
;  call ACLS

  mov si,msg1
  call STR2SCR                ; routine to cope with this funny format

  mov si, msg2
  call STR2SCR

  mov si, msg3
  call STR2SCR

  mov si, msg4
  call STR2SCR

  mov si, msg5
  call STR2SCR

  mov si, msg6
  call STR2SCR

  mov si, amsg1
  call CA2SCR          ; routine to do char,attrib,... format

  mov si,press            ; point to formatted message
  call SETTEXTBOX         ; calculate a box to surround text
aboxdraw:
  call DRAWABOX           ; draw the box
  call STR2SCR            ; show the text at specified position, color

  push si
  mov si, amsg1
  call CAROTATE        ; "rotate" colors in string until key hit
  pop si

  cmp al,01Bh             ; esc quits
  jz exit
  mov al,[aboxc1]         ; else swap colors
  mov ah,[aboxc2]
  mov [aboxc1],ah
  mov [aboxc2],al
  cmp si,release          ; and toggle message
  jz repress
  mov si,release
  jmp aboxdraw            ; do it again
repress:
  mov si,press
  jmp aboxdraw            ; and again

exit:
  mov ax,0720h         ; white-on-black, spaces
  call ACLS            ; clear screen to "normal"

  mov ax,04C00h        ; and quit
  int 021h


; -------------------------------------------------------------
; ACLS - fill screen with char in al, attribute (color) in ah
;        expects screen segment in [vidseg]
; ------------------------------------------------------------
ACLS 
  push cx
  push di
  push es
  mov es,[vidseg]
  xor di,di
  mov cx,07d0h
  rep stosw
  pop es
  pop di
  pop cx
  ret
; -------------------------------------------------------------


; ----------------------------------------------------------------
; STR2SCR    - direct screen write version
; Expects: string 
;          dw row,column
;          db colors
;          db 'whatever',0
;       si=offset string
;  Returns: si=offset string
; -------------------------------------------------------------------

STR2SCR ; proc
  push bx
  push dx
  push si                    ;points to position  (word)

  mov dx,[si]         ; row in high byte, column in low
  inc si
  inc si
  mov bl,[si]         ; attribute (color)
  inc si                 ; our message at last
  call PSTRATT

  pop si
  pop dx
  pop bx

  ret
; ------------------end STR2SCR-------------------------------

; ----------------------------------------------------------------
; PSTRATT    - direct screen write version - screen seg in vidseg
; Expects:  si=offset zero terminated string
;          dx=row:column
;          bl=attribute to use
;          screen seg in vidseg
; -------------------------------------------------------------------

PSTRATT ; proc
  push ax
  push si
  push di
  push es
  mov es,word[vidseg]
  call RC2OFFS        ; convert row,col in dx to offset in di
  mov ah,bl           ; color (attribute) for text
putnxt:
  lodsb               ; get character
  or al,al            ; terminating zero?
  jz psatdun
  stosw               ; put character and attribute on screen
  jmp putnxt
psatdun:
  pop es
  pop di
  pop si
  pop ax
  ret
; ------------------end PSTRATT-------------------------------

;-----------------------------------------------------------
; convert row,column in dx to offset into screen memory in di
;------------------------------------------------------------
RC2OFFS
  push dx             ; save callers reg
  push dx             ; save us a copy of row/column
  and dx,0ff00h       ; mask off row
  shr dx,02h          ; row times 64
  mov di,dx
  shr dx,02h          ; row times 16
  add di,dx           ; row * 64 + row * 16 = row * 80
  pop dx              ; get row/column back
  and dx,00ffh        ; mask off column
  add di,dx           ; add it - di is number of characters into screen
  shl di,01h          ; times 2 bytes per character
  pop dx              ; restore callers reg
  ret                 ; now di is our offset into screen
;----------------------------------------------------------------


; ----------------------------------------------------------------
; CA2SCR
; Expects:string db column,row,'w',<attrib>,'h',<attrib>
;                db 'a',<attrib>,'t',<attrib>,'ever',00h
;       si= stringlen   
; -------------------------------------------------------------------

CA2SCR
push ax
push di
push dx
push es

mov es,[vidseg]
mov dx,[si]
call RC2OFFS         ; convert row,col in ax to offset in di
add si,02h
ca2scrnxt:
lodsw            ; move character,attribute to screen
or al,al
jz ca2scrdun
stosw
jmp ca2scrnxt
ca2scrdun:

pop es
pop dx
pop di
pop ax
ret
; ------------------end CA2SCR-------------------------------

;-------------------------------------------------------------
; CAROTATE  rotates foreground colors
; Expects: string db column,row,'w',<attrib>,'h',<attrib>
;                 db 'a',<attrib>,'t',<attrib>,'ever',00h
;          
;       si-> stringlen   
; -------------------------------------------------------------------
CAROTATE
push bx
push cx
push dx
push di
push si
push es

mov es,[vidseg]
mov dx,[si]       ; row in high byte, column in low
call RC2OFFS
mov cx,di         ; save offset into screen in cx
add si,02h
mov bx,si         ; save offset to text,att in bx
nxtrot:
mov si,bx         ; restore offset to text
mov di,cx         ; restore offset into screen
nxtatt:
lodsw               ; get character, attribute
or al,al            ; terminating zero?
jz carotdun

inc di              ; skip over character
mov al,[es:di]      ; get current attribute
mov ah,al           ; stash bg/fg
and al,0fh          ; isolate foreground color
inc al              ; bump it
cmp al,010h         ; is color = 16 ( =0) yet?
jnz C1
mov al,01h          ; if so, start over with color 1
C1:
and ah,0f0h         ; isolate stored background color
or al,ah            ; restore bg/fg to al
mov [es:di],al      ; put it back
inc di              ; and do next
jmp nxtatt
carotdun:

call DELAY1         ; too fast without some delay
call DELAY1
call DELAY1
call DELAY1

;mov ah,0Bh          ; check input status
;int 021h
;cmp al,0h           ; returns zero if no key ready
;je nxtrot           ; so continue rotating colors
;mov ah,08h          ; else eat the key so it won't stay 
;int 021h            ; on the kb buffer to haunt us later
mov ah,01h
int 016h
jz nxtrot
xor ax,ax
int 016h



pop es
pop si
pop di
pop dx
pop cx
pop bx
ret
; ------------end CAROTATE-----------------------------------


;-----------------------------------------------------------------
; Simple BIOS delay - wildly inaccurate! the word at 40:6C is
; incremented 18.2 times per second, but we might get here just
; before it changes. Probably averages around 1/36 sec (?)
;-----------------------------------------------------------------
DELAY1    
        push bx
        push    ds
        mov     bx,0040h       ; BIOS data segment
        mov     ds,bx
        mov     bx,6Ch         ; BIOS timer, 40:6C
        mov     al,[bx]
DelayLoop:
        cmp     al,[bx]        ; Is it the same?
        je      DelayLoop      ; Yes, try again.
        pop     ds             ; Restore registers and exit.
        pop bx
        ret
;------------------------------------------------------------------

;---------------------------------------------------------------------
DRAWABOX
  push ax
  push bx
  push cx
  push si
  push di
  push es

  mov es,[vidseg]

  mov dh,[aboxy1]
  mov dl,[aboxx1]
  call RC2OFFS

  mov dx,050h                
  sub dl,[aboxx2]       ; dx = bytes to add to screen memory to
  add dl,[aboxx1]       ; move to next row starting offset
  shl dx,01h

  sub bh,bh
  mov bl,[aboxx2]        ; bx stores length of "middle" section of box,
  sub bl,[aboxx1]        ; excluding ends
  sub bx,02h             
                       

  mov al,[aboxlt]        ; left top corner box character
  mov ah,[aboxc1]        ; color for left and top sides
  stosw                  ; put character and attribute on screen
  mov al,[aboxhor]       ; top line
  mov cx,bx              ; length of "middle" section
  rep stosw
  mov ah,[aboxc2]        ; color for right and bottom sides
  mov al,[aboxrt]        ; right top corner box character
  stosw

  sub ch,ch
  mov cl,[aboxy2]
  sub cl,[aboxy1]
  sub cl,02h             ; loop count for "middle" rows

  mov al,[aboxver]       ; vertical line box character
aboxmiddle:
  push cx                ; save rows count
  add di,dx              ; move to next row
  mov ah,[aboxc1]        ; color for left and top sides
  stosw
  mov ah,[aboxc2]        ; color for right and bottom sides
  mov al,[aboxblank]     ; center of box "fill" character - normally space
  mov cx,bx              ; "middle" columns count
  rep stosw
  mov al,[aboxver]       ; vertical line box character
  stosw
  pop cx                 ; restore "middle" rows count
  loop aboxmiddle

  add di,dx              ; move to next row
  mov ah,[aboxc1]        ; color for left and top sides
  mov al,[aboxlb]        ; left bottom corner box character
  stosw
  mov ah,[aboxc2]        ; color for right and bottom sides
  mov al,[aboxhor]
  mov cx,bx              ; count of "middle" columns
  rep stosw
  mov al,[aboxrb]        ; right bottom corner box character
  stosw

  pop es
  pop di
  pop si
  pop cx
  pop bx
  pop ax
  ret
;--------------------------------------------------------------

;----------------------------------------------------------------
SETTEXTBOX
  push ax
  push bx
  push si
  mov al,[si+01h]         ; row of text message
  dec al                  ; start one before it
  mov [aboxy1],al
  add al,03h              ; end one after it
  mov [aboxy2],al
  mov al,[si]             ; text column
  dec al                  ; start one before it
  mov [aboxx1],al
  xor bx,bx
boxtextwalk:               ; stringlength routine
  cmp byte[si+bx+03h],00h
  jz boxtextx2
  inc bx
  jmp boxtextwalk
boxtextx2:
  add al,bl
  inc al
  inc al
  mov [aboxx2],al         ; end one after text
  mov al,[si+02h]         ; text color
  mov [aboxc2],al         ; use for right and bottom sides of box
  mov ah,al               ; save background color
  shr al,04h              ; get background color
  add al,08h              ; make it bright
  and ah,0F0h
  add al,ah               ; and use it for foreground
  mov [aboxc1],al         ; use for left and top sides of box
  pop si
  pop bx
  pop ax
  ret
;-----------------------------------------------------------------
