org 0100h

segment .data
    cmdlnmsg db 'Command line Parameters:',00h
    parammsg db 'Parameter ',00h
    envirmsg db 'Environment Variables:',00h
    putcmethod dw CHAROUT

segment .bss
    parambuf resb 0100h      ; max path + max cmdline
    paramtbl resw 040h
    paramcnt resb 01h
                             ; no one would have a bigger
    envirbuf resb 0400h      ; environment than this... would they?
    envirtbl resw 020h       ; or more variables???
    envircnt resb 01h


segment .text
    call GET_PARAMS          ; get commamd line args
                             ; and environment variables
    mov si,cmdlnmsg          ; print command line args
    call PUTCENTERED
    call CRLF
    xor cx,cx
showem:
    mov si,parammsg
    call PUTASCZ
    mov al,cl
    add al,'0'               ; this cheap-ass method won't work
    call [putcmethod]        ; with more than 9 parameters ...
    mov al,':'
    call [putcmethod]
    mov al,' '
    call [putcmethod]
    mov bx,cx
    add bx,bx
    add bx,paramtbl
    mov si,[bx]
    call PUTASCZ
    call CRLF
    inc cx
    cmp cl,[paramcnt]
    jc showem
                             ; print environment variables
    mov si,envirmsg
    call PUTCENTERED
    call CRLF
    xor cx,cx
showenv:
    mov bx,cx
    add bx,bx
    add bx,envirtbl
    mov si,[bx]
    call PUTASCZ
    call CRLF
    inc cx
    cmp cl,[envircnt]
    jc showenv

exit:
    mov ah,04Ch
    int 021h
;---------------------------------------------------------

;---------------------------------------------------------
GET_PARAMS
    mov di,envirbuf     ; buffer to store strings
    mov [envirtbl],di   ; save its address as envirtbl[0]
    xor cx,cx           ; zero count of variables
    push ds             ; save ds (=cs=es=PSP)
    mov ds,[02Ch]       ; get environment seg in ds
    xor si,si           ; start at environment_seg:0
walkenvir:
    lodsb               ; get a char
    stosb               ; save it
    or al,al            ; was it the terminating 0?
    jnz walkenvir       ; nope, do more
gotoneenvir:
    cmp byte[si],00h    ; env vars end with 0,0
    jz gotenvir         ; found end
    inc cx              ; bump the count
    mov bx,cx           ; convert to index
    add bx,bx           ; into word array
    mov [es:envirtbl+bx],di  ; save address of next string
    jmp walkenvir        ; and go get it
gotenvir:                ; environment variables done, get prog name
    mov [es:envircnt],cl      ; save number of env vars
    add si,03h                ; skip over word (!) sized count
                              ; of additional strings
                              ; is this ever other than 1 ???

    mov di,parambuf        ; get "argv[0]" - program drive/path/name
    mov [es:paramtbl],di   ; save its address in array
getprognamechar:
    lodsb                  ; get a char
    stosb                  ; and store it
    or al,al               ; terminating zero?
    jnz getprognamechar    ; no, do more
    pop ds           ; done with environment seg, restore PSP seg

    xor cx,cx             ; zero count of cmd line args
    mov si,081h           ; ignore command line length at PSP:80h
getparamchk:              ; instead, start at PSP:81h and
    cmp byte[si],0Dh      ; watch for CR
    jz getparamdone       ; no parameters given?
    cmp byte[si],' '      ; junk leading space(s)
    jnz getparamok
    inc si
    jmp getparamchk
getparamok
    inc cx               ; got at least one, bump count
getnextparam:
    mov bx,cx            ; convert count
    add bx,bx            ; to index into word array
    mov [paramtbl+bx],di   ; save address of string
getparamskip:
    cmp byte[si],' '
    jnz getparamchar
    inc si
    cmp byte[si],0Dh
    jnz getparamskip2
    dec cx
    jmp gotparameters
getparamskip2:
    jmp getparamskip
getparamchar:
    lodsb                ; get char
    cmp al,0Dh           ; keep watching for end of cmd line
    jz gotparameters
    cmp al,' '           ; or end of parameter
    jz gotoneparam       ; should we check for other delimiters (','?)
    stosb                ; else store it
    jmp getparamchar     ; and do more
gotoneparam:
    inc cx
    mov al,00h           ; zero-terminate the string
    stosb
    jmp getnextparam     ; and get another (if any)
gotparameters:
    mov al,00h           ; terminate the last string
    stosb
    inc cx               ; bump the count
getparamdone:
    mov [paramcnt],cl    ; save count
    ret
;--------------------end GET_PARAMS------------------------

;----------------------------------------------------------
; output zero-terminated string pointed
; to by (ds:)si, via [putcmethod]
; returns - nothing: all registers preserved 
;---------------------------------------------------------
PUTASCZ ; proc
  push ax
  push si
ptz1:
  lodsb
  cmp al,00h
  jz ptz2
  call [putcmethod]
  jmp ptz1
ptz2:
  pop si
  pop ax
  ret
;--------------------------------------------------------------

;-------------------------------------------------
; dos stdout version
;-------------------------------------------------
CHAROUT
  push dx
  mov dl,al
  mov ah,02h
  int 021h
  pop dx
  ret
;--------------------end CHAROUT------------------------

; ----------------------------------------------------------
; prints a CR/LF pair via [putcmethod]
; ------------------------------------------------------
CRLF
  push ax
  push dx
  mov al,0Dh
  call [putcmethod]
  mov al,0Ah
  call [putcmethod]
  pop dx
  pop ax
  ret
; --------------------------end CRLF-----------------------

;-----------------------------------------------------------
STRLEN
  push si
strlenmore:
  cmp byte[si],00h
  jz strlendone
  inc si
  jmp strlenmore
strlendone:
  mov ax,si
  pop si
  sub ax,si
  dec ax
  ret
;----------------------------------------------------------

;---------------------------------------------------------
PUTCENTERED
  push ax
  push cx
  call STRLEN
  mov cx,050h
  sub cx,ax
  shr cx,01h
putcenteredspc:
  mov al,' '
  call [putcmethod]
  loop putcenteredspc
  call PUTASCZ
  pop cx
  pop ax
  ret
;--------------------------------------------------------
