; draw in ? mode
%include "keyequ.inc"

[org 0100h]

CHAR_WIDTH  EQU 8
CHAR_HEIGHT EQU 8
CHAR_START1 EQU 0xf000
CHAR_START2 EQU 0xfa6e

%macro LINE 4
    mov word[x1],%1
    mov word[x2],%2
    mov word[y1],%3
    mov word[y2],%4
    call JRLINE
%endmacro

%macro BOX 4
    LINE %1,%2,%3,%3
    LINE %2,%2,%3,%4
    LINE %2,%1,%4,%4
    LINE %1,%1,%4,%3
%endmacro

%macro CURS17 0
    mov ax,[curx]
    sub ax,20
    mov [x1],ax
    add ax,15
    mov [x2],ax
    mov ax,[cury]
    mov [y1],ax
    mov [y2],ax
    call JRLINE
    mov ax,[curx]
    add ax,5
    mov [x1],ax
    add ax,15
    mov [x2],ax
    call JRLINE
    mov ax,[curx]
    mov [x1],ax
    mov [x2],ax
    mov ax,[cury]
    sub ax,20
    mov [y1],ax
    add ax,15
    mov [y2],ax
    call JRLINE
    mov ax,[cury]
    add ax,5
    mov [y1],ax
    add ax,15
    mov [y2],ax
    call JRLINE
%endmacro

[section .data]
row dw 0D8h                 ;058h
column dw 01Dh
txtfg db 01h
txtbg db 00h

x1 dw 0
x2 dw 639
y1 dw 0
y2 dw 0
linecolor db 01h

txtmsg db 'Enter text to place:  ',00h
grmsg db 'Now in graphics mode.',00h

              
[section .bss]
    ascbuf resb 080h
    grtxtbuf resb 080h

    homeseg resw 01h
    vidmode resb 01h
    vscrseg resw 01h
    ascrseg resw 01h
    ascrlen resd 01h
    xdots resw 01h
    ydots resw 01h

    curx resw 01h
    cury resw 01h
    oldx resw 01h
    oldy resw 01h

    drawmethod resw 01h
    putpixlmethod resw 01h
    charout resw 01h


    mystack resb 0400h
zzz:

[section .text]
    mov word[homeseg],cs
    mov bx,zzz                 ; move stack down
    mov sp,bx                  ; shrink memory block
    add bx,0Fh                 ; to just what we need
    shr bx,04h
    mov ah,04Ah                ; resize memory block
    int 021h
    jnc okshrink
    jmp exit
okshrink:
    mov word[charout],CHAROUT
    call INITVID17
    mov ax,[ascrlen]                ; get a buffer
    add ax,0Fh
    shr ax,04h
    call ALLOC
    jnc okalloc
    jmp exit
okalloc:
    mov word[vscrseg],ax

    mov es,[ascrseg]

    BOX 20,620,20,460
    BOX 40,600,40,440
    BOX 60,580,60,420

    LINE 230,390,240,280
    mov cx,[column]
    mov dx,[row]
    mov si,grmsg
    call PUTASCZTILT
call SAVSCR
    mov word[curx],100
    mov word[cury],100
    mov word[drawmethod],DUMMYRET

p1:
    call RESTSCR
    call [drawmethod]
    CURS17
    mov ah,010h   ; this gets control-up + control-down - ah=0 not!!!
    int 016h
    cmp al,00h
    je extasci
    cmp al,01Bh
    jne notesc
    jmp exit
notesc:

    cmp al,ENTERK
    jnz notenterk
    call RESTSCR
    call [drawmethod]
    call SAVSCR
    mov ax,[curx]
    mov [oldx],ax
    mov ax,[cury]
    mov [oldy],ax
    jmp p1
notenterk:

    cmp al,'t'
    jnz nottkey
    call INITVID3
    mov si,txtmsg
    call PUTASCZ
    xor si,si
    mov di,grtxtbuf
    mov cx,050h
    call USRSTR
    call INITVID17
    call RESTSCR
    mov word[drawmethod],PUTASCZ17
    jmp p1
nottkey:

    cmp al,'d'
    jnz notdkey
    mov word[drawmethod],DRAWLINE17
    mov ax,[curx]
    mov [oldx],ax
    mov ax,[cury]
    mov [oldy],ax
    jmp p1
notdkey:

    cmp al,'m'
    jnz notmkey
    mov word[drawmethod],DUMMYRET
    jmp p1
notmkey:


    ; check other "non-extended-ascii" keys here
extasci:

    cmp ah,UP
    jnz notup
    dec word[cury]
    jmp p1
notup:

    cmp ah,DN
    jnz notdown
    inc word[cury]
    jmp p1
notdown:

    cmp ah,LEFT
    jnz notleft
    dec word[curx]
    jmp p1
notleft:

    cmp ah,RIGHT
    jnz notright
    inc word[curx]
    jmp p1
notright:

    cmp ah,CNTL_UP
    jnz notcup
    sub word[cury],10
    jmp p1
notcup:

    cmp ah,CNTL_DN
    jnz notcdn
    add word[cury],10
    jmp p1
notcdn:

    cmp ah,CNTL_LEFT
    jnz notcleft
    sub word[curx],10
    jmp p1
notcleft:

    cmp ah,CNTL_RIGHT
    jnz notcrt
    add word[curx],10
    jmp p1
notcrt:

    jmp p1

   mov es,[homeseg]

xor ax,ax
int 016h
call SAVSCR

xor ax,ax
int 016h

exit:
    mov ax,0003h
    int 010h
    mov ah,04Ch
    int 021h
;-------------------------------------------------

;---------------------------------
DUMMYRET
    ret
;----------------------------------



;---------------------------------------
SAVSCR
   push ds
   push es
   push si
   push di
   push cx
   mov cx,[ascrlen]
   shr cx,01h
   mov es,[vscrseg]
   mov ds,[ascrseg]
   xor di,di
   xor si,si
   rep movsw
   pop cx
   pop di
   pop si
   pop es
   pop ds
   ret
;-----------------------------------

;---------------------------------------
RESTSCR
   push ds
   push es
   push si
   push di
   push cx
   mov cx,[ascrlen]
   shr cx,01h
   mov es,[ascrseg]
   mov ds,[vscrseg]
   xor di,di
   xor si,si
   rep movsw
   pop cx
   pop di
   pop si
   pop es
   pop ds
   ret
;-----------------------------------


;----------------------------------------
INITVID17
    push ax
    mov ax,0011h 
    int 010h
    mov byte[vidmode],011h
    mov word[ascrseg],0A000h
    mov word[xdots],640
    mov word[ydots],480
    mov word[ascrlen],38400
    mov word[ascrlen+2],0
    mov word[putpixlmethod],PUTPIXEL17
    pop ax

    ret
;----------------------------------------

;----------------------------------------
INITVID3
    push ax

    mov ax,0003h
    int 010h
    mov byte[vidmode],03h
    mov word[ascrseg],0B800h
    mov word[xdots],160
    mov word[ydots],25
    mov word[ascrlen],4000
    mov word[ascrlen+2],0
    mov word[putpixlmethod],CHAROUT
    mov word[charout],CHAROUT
    pop ax

    ret
;----------------------------------------


;------------------------------------------
ALLOC
    push bx
    mov bx,ax
    mov ah,48h
    int 21h
    jnc allocdone
    mov ax,00h
    sec
allocdone:
    pop bx
ret
;---------------------------------------------

;--------------------------------------
;Author: John Ribera
;Date:   10-21-85
;Purpose: Draw a line calling a function
;         for each point.
;www.mindspring.com/~kilroy
;jjr@dcm.net
;
;--------------------------------------
JRLINE
                mov             cx,[x1]
                mov             si,[x2]
                mov             dx,[y1]
                mov             di,[y2]
X2_X1:  MOV		AX, CX
        SUB		AX, SI		;ax = x2-x1
        MOV		CH, 49H		;ASSUME INC CX
        JNC		Y2_Y1
        MOV		CH, 41H		;GONNA BE DEC CX
        NEG		AX			;ax = abs(x2-x1)
Y2_Y1:  MOV		BX,DX		;bx = y2-y1
        SUB		BX,DI
        MOV		CL,4AH		;ASSUME DEC DX
        JNC		CMP_XY
        MOV		CL,42H		;GONNA BE INC DX
        NEG		BX			;bx = abs(y2-y1)
CMP_XY: CMP		AX,BX
        JG		dxGTdy		;if (dx > dy)
        XCHG	AX,BX		;  xchg dx <-> dy
        XCHG	CL,CH		;  xchg rise <-> run
dxGTdy: MOV		SI,BX		;si = min(dx, dy)
        MOV		DI,AX		;di = ax = max(dx, dy)
	cmp		ax, 0
        jz              exitjrl
        MOV             WORD[CS:RISE],CX
INITLP: mov             cx,[x1]       ;RESTORE X2 (starting point)
        XOR		BX,BX		;bx is numerator
nextpt: ADD		BX,SI		;bx += min(dx, dy)
        CMP		BX,DI		;if (bx > max(dx, dy))
        JL		RUN			;  bx -= max(dx, dy)
        SUB		BX,DI
RISE:   INC		CX
RUN:    INC		DX          ;ALWAYS RUN ONCE
     push ax
     mov al,[linecolor]
     call    word[putpixlmethod]       ;PUTPIXEL17
     pop ax
        DEC		AX
        JNZ		nextpt
exitjrl:
        RET
;--------------------------------------------------------

;--------------------------------------------------------
DRAWLINE17
    mov ax,[oldx]
    mov word[x1],ax
    mov ax,[curx]
    mov word[x2],ax
    mov ax,[oldy]
    mov word[y1],ax
    mov ax,[cury]
    mov word[y2],ax
    call JRLINE
    ret
;----------------------------------


;--------------------------------------------------------
PUTPIXEL17
push ax
push cx
push dx
push di

push ax
mov ax,640        ; y * 640 + x
mul dx
add ax,cx         ; bit offset
adc dx,00h
mov cx,08h
div cx
mov di,ax         ; byte offset
mov cx,dx         ; bit within byte
pop ax
test ax,01h
jz pp17off

mov al,080h      ; turn pixel on
shr al,cl
or byte[es:di],al
jmp pp17end

pp17off:
mov al,07Fh
shr al,cl
and byte[es:di],al

pp17end:
pop di
pop dx
pop cx
pop ax
ret
;-------------------------------------------

;-----------------------------------------------
PUTASCZ ; proc
  push ax
  push si
ptz1:
  lodsb
  cmp al,00h
  jz ptz2
  call [charout]
  jmp ptz1
ptz2:
  pop si
  pop ax
  ret
;--------------------------------------------------------------

;-----------------------------------------------
PUTASCN ; proc
  push ax
  push si
ptn1:
  lodsb
  call [charout]
  loop ptn1
  pop si
  pop ax
  ret
;--------------------------------------------------------------

;-------------------------------------------------------
CHAROUT
    push dx
    mov dl,al
    mov ah,02h
    int 021h
    pop dx
    ret
;---------------------------------------------------------

;---------------------------------------------------------
LPTOUT
    push ax
    push dx
    mov dl,al
    mov ah,05h
    int 021h
    pop dx
    pop ax
    ret
;--------------------------------------------------------

; ----------------------------------------------------------
; prints a CR/LF pair to std out
; ------------------------------------------------------
CRLF ; proc
  push ax
  push dx
  mov al,0dh
  call [charout]
  mov al,0Ah
  call [charout]
  pop dx
  pop ax
  ret
;CRLF endp
; --------------------------end CRLF-----------------------

;--------------------------------------------------------------
; CLS - cheapo version - reset to "vidmode"
;--------------------------------------------------------------
CLS ; proc near
    push ax
    xor ax,ax
    mov al,byte[vidmode]
    int 010h
    pop ax
ret
;--------------------------------------------------------------


;--------------------------------------------------------------
PUTASCZTILT
    push ax
    push cx
    push dx

redraw:
    lodsb
    cmp al,00h
    je WaitForKey
    CALL DrawChar
    add cx,1             ;CHAR_WIDTH
    add dx,02h
    cmp cx,80
    jbe redraw
    xor cx,cx
    add dx,1             ;CHAR_HEIGHT
    jmp redraw
WaitForKey:
    pop dx
    pop cx
    pop ax
    ret
;---------------------------------------------------------------

;--------------------------------------------------------------
PUTASCZ17
    push ax
    push bx
    push cx
    push dx
    push si

    mov ax,[curx]
    mov cx,CHAR_WIDTH
    xor dx,dx
    div cx
    mov cx,ax

    mov dx,[cury]
    sub dx,CHAR_HEIGHT

    mov si,grtxtbuf
redraw17:
    lodsb
    cmp al,00h
    je putascz17exit
    CALL DrawChar
    add cx,1             ;CHAR_WIDTH
;    add dx,02h
    cmp cx,80
    jbe redraw17
    xor cx,cx
    add dx,1             ;CHAR_HEIGHT
    jmp redraw17
putascz17exit:
    pop si
    pop dx
    pop cx
    pop bx
    pop ax
    ret
;---------------------------------------------------------------


;==============
DrawChar:
;==============
PUSH AX ;counting
PUSH BX ;bitmask
PUSH CX ;CH xcount, CL ycount
push dx
PUSH ES ;screen ram
PUSH DI ;offset

PUSH DS ;char rom
PUSH SI ;work_char
        push ax ; char to draw
                            ;es:di is screen ram
        MOV AX,[ascrseg]
        MOV ES,AX
        mov ax,80
        mul dx
    add ax,cx         ; byte offset
    mov di,ax         ; byte offset

                           ;ds:si is the char rom
        MOV AX, CHAR_START1
        MOV DS,AX
        MOV SI, CHAR_START2
        pop ax
        and ax,00FFh
        mov dx,CHAR_HEIGHT
        mul dx
        add si,ax
   MOV CL, 0h
YLOOP:
    MOV AL, [DS:SI]
    test byte[cs:txtfg],1
    jz nopixel
    or byte[es:di],al
    jmp donepixel
nopixel:
    xor al,0FFh
    and byte[es:di],al
donepixel:
    ADD DI,80    ; (320-char width) 320 ;offset+=320
    ADD SI, 1   ;work_Char++
    inc cl
    CMP CL,CHAR_HEIGHT
    JNZ YLOOP

    POP SI
    POP DS
    POP DI
    POP ES
    pop dx
    POP CX
    POP BX
    POP AX

    RET
;--------------------------------------------

;--------------------------------------------
PUTPIXEL19
push ax
push cx
push dx
push di

push ax
mov ax,320
mul dx
add ax,cx
mov di,ax
pop ax
mov [es:di],al
pop di
pop dx
pop cx
pop ax
ret
;-------------------------------------------


;-------------------------------------------
DELAY
    push ax
    push bx
    push ds

    mov ax,040h
    mov ds,ax
    mov bx,[06Ch]
delay1:
    mov ax,[06Ch]
    cmp ax,bx
    jz delay1
    mov bx,ax
delay2:
    mov ax,[06Ch]
    cmp ax,bx
    jz delay2

    pop ds
    pop bx
    pop ax
    ret
;------------------------------------------------------------

;--------------------------------------------------------------------
; USRSTR - gets a string from user via CHK4CHAR
; expects: SI=default string or SI=0 - default better fit in buffer!
;          DI=buffer to receive string - better be big enough!
;          CX= max length to get - including terminating 0
; calls:   GETCURSOR, SETCURSOR, PUTASCZ, CHAROUT, CHK4CHAR
;          these can be changed to get from stdio, bios, remote, etc.
; returns: SI points to zero terminated string
;          AX=last key pressed (check for ESC, error)
;          CX=length gotten (including 0)
;          BX,DX preserved
;          DI destroyed
;-------------------------------------------------------------------

USRSTR
  push bx                        ; save caller's bx,dx
  push dx
  push di                        ; save input buffer address (popped to si)
  xchg cl,ch                     ; get max len in high byte
  push cx                        ; save max len (to be restored in di)
  call GETCURSOR                 ; row:col in dx, size in cx
  xor bx,bx                      ; position, length start at 0
  cmp si,00h                     ; we don't have a default string
  jz nodef
moredef:                         ; copy default string to inbuf
  inc bl                         ; bump position
  inc bh                         ; bump length
  lodsb
  stosb
  cmp al,00h
  jnz moredef
  dec bh
  dec bl
  pop di                         ; di=max length in high byte
  pop si                         ; si = inbuf
  jmp firstkey                   ; commence input
nodef:
  pop di                         ; di=max length in high byte
  pop si                         ; si = inbuf
  mov byte[si],00h               ; terminate the (null) string
  jmp nextkey                    ; commence input
firstkey:                  ; special input for first char (if default string)
  call SETCURSOR                ; (to "home" position)
  call PUTASCZ                  ; show default string
  call CHK4CHAR
  cmp ax,0FFFFh
  jnz usrok
  jmp usrstrdun
usrok:
  cmp al,'\'                    ; assume backslash intended to be added
  je notfirst                   ; don't erase default
  cmp al,021h                   ; assume space intended to be added
  jl notfirst                   ; don't erase default
                       ; erase the default - we don't want it
  push ax                       ; save our character
  call SETCURSOR                ; start at "home" position
  mov al,' '                    ; put spaces
erase:
  call [charout]
  dec bh
  jne erase                     ; ... for entire length
  mov byte[si],00h              ; terminate the (null) string
  call SETCURSOR                ; back to "home"
  xor bx,bx                     ; position, length back to 0
  pop ax                        ; restore the character
  jmp notfirst                  ; treat character as normal input
nextkey:                        ; main input loop
  call SETCURSOR                ; to "home" position
  call PUTASCZ                  ; show what we've got so far
  mov al,' '                    ; put a space - in case we're backing up
  call [charout]                  ; (this space isn't part of our string)
  push dx                       ; save our "home" position
  add dl,bl                     ; adjust
  call SETCURSOR                ; to input position
  pop dx                        ; restore "home" position
  call CHK4CHAR
notfirst:                       ; entry point for "first key" routine
  cmp ax,0FFFFh
  jnz usrokay
  jmp usrstrdun
usrokay:
  
  cmp al,00h                    ; is it an extended/editing key?
  jnz usrstrascii               ; nope - check "regular" keys
                       ; check  editing keys
  cmp ah,LEFT
  jnz usnotleft
  cmp bl,00h                    ; are we at beginning of string? - ignore
  jz nextkey
  dec bl                        ; else move position left
  jmp nextkey
usnotleft:
  cmp ah,RIGHT
  jnz usnotright
  cmp bh,bl                      ; are we at end of string? - ignore
  jz nextkey
  inc bl                        ; else move position right
  jmp nextkey
usnotright:
  cmp ah,HOME
  jnz usnothome
  xor bl,bl                     ; position 0
  jmp nextkey
usnothome:
  cmp ah,ENDK
  jnz usrnotendk
  mov bl,bh                     ; position is at end of string
  jmp nextkey
usrnotendk:
  cmp ah,INSERT
  jnz usnotins
  xor cx,01D00h               ; toggle cursor size (bit 15 is overwrite mode)
  jmp nextkey
usnotins:
  cmp ah, DEL
  jnz usnotdel
  cmp bl,bh                   ; end of string? - ignore
  jnz usrdragleft             ; use the "backspace" code 
  jmp nextkey
usnotdel:
                    ; might want to support UP, DN, PGDN, F1, etc.
  jmp nextkey                     ; an editing key, but not one we want
usrstrascii:                      ; check regular ascii keys
  cmp al,BS
  jnz usnotbs
  cmp bl,00h                      ; beginning of string? ignore
  jz nextkey
  dec bl                          ; move position back
usrdragleft:                      ; entry point for "delete" routine
  dec bh                          ; shorten length
  push bx                         ; save length:position
  and bx,00FFh                    ; get just position
usdrag:
  mov al,[si+bx+1]                ; character from "next" position
  mov [si+bx],al                  ; goes in "current" position
  inc bx                          ; cook
  cmp al,00h                      ; 'til done
  jnz usdrag
  pop bx                          ; restore length:position
  jmp nextkey
usnotbs:
  cmp al,ESC                      ; just quit - let caller deal with it
  jz usrstrdun
  cmp al,ENTERK                   ; must think we have our string!
  jz usrstrdun
                       ; must be a real addition to our string
  cmp bh,bl                       ; end of string?
  jnz usrmidstr                   ; nope - do middle of string routine
  inc bh                          ; yep - increase length
  cmp di,bx                       ; check for overflow (di= max in high byte)
  jae usrstradd                   ; we're ok - add it
overflow:
  dec bh                          ; put length back to safe level
  mov al,BEEPK                    ; toot the damn speaker
  call [charout]
  jmp nextkey                     ; and ignore the input
usrmidstr:                        ; middle of string routine
  test cx,01000h                  ; insert mode?
  jnz usrstradd                   ; no - just do it
                       ; make a space for our character
  inc bh                          ; bump length
  cmp di,bx                       ; check for overflow
  jb overflow                     ; beep and ignore
  push ax                         ; save the character
  push bx                         ; save length:position
usrpushrt:                        ; push from position to end right
  push bx                         ; save pseudo length:position
  mov bl,bh                       ; get just length
  and bx,00FFh
  mov al,[si+bx-1]                ; character in "previous" position
  mov [si+bx],al                  ; goes in "current" position
  pop bx                          ; restore pseudo length:position
  dec bh                          ; move back to previous character
  cmp bl,bh                       ; 'til we reach the "real" input position
  jnz usrpushrt
  pop bx                          ; restore the "real" length:position
  pop ax                          ; restore the character
usrstradd:                        ; put a character in our string - finally!
  push bx                         ; save length:position
  and bx,00FFh                    ; get just position
  mov byte[si+bx],al              ; put our character there
  pop bx                          ; restore length:position
  push bx                         ; save length:position
  mov bl,bh                       ; get just length
  and bx,00FFh
  mov byte[si+bx],00h             ; terminate string (needed if EOS, no harm)
  pop bx                          ; restore length:position
  inc bl                          ; increase input position
  jmp nextkey                     ; get more
usrstrdun:                        ; routine terminated by esc/enter
  mov cx,0707h                    ; restore "normal" cursor
  call SETCURSOR
  mov bl,bh                       ; whoopie! don't have to save it!
  and bx,0FFh                     ; get just length
  mov cx,bx                       ; return it in cx
  pop dx                          ; restore caller's dx
  pop bx                          ;    "       "     bx
  ret                             ; if we ain't got it, we ain't gonna
; USRSTR endp
;----------------------------------------------------------------------

;-------------------------------------------------------
CHK4CHAR
  xor ax,ax
  int 016h
  ret
; CHK4CHAR endp
;----------------------------------------------------------

;----------------------------------------------------------
SETCURSOR
  push ax
  push bx
  mov ah,01h                     ; set cursor to size in cx
  mov bh,00h                     ; video page zero
  int 010h                       
  mov ah,02h                     ; set cursor position to dx (row:column)
  int 010h
  pop bx
  pop ax
  ret
; SETCURSOR endp
;---------------------------------------------------------

;--------------------------------------------------------
GETCURSOR
  push ax
  push bx
  mov ah,03h                     ; get cursor position,size
  mov bh,00h                     ; video page zero
  int 010h                       ; cursor pos in dx - size in cx
  pop bx
  pop ax
  ret
; GETCURSOR endp
;--------------------------------------------------------------
