org 100h
section .text

        ; first, lets write to a file that's already open,
        ; standard output - normally the screen.

    mov ah,040h        ; the Write-to-a-file function for int 21h
    mov bx,1           ; the file handle for standard output
    mov cx,[msg_len]   ; number of bytes to write
    mov dx,msg         ; address of our "buffer" to write from
    int 021h           ; call on Good Old Dos

       ; now, lets read from a file that's already open,
       ; standard input - normally the keyboard.

    mov ah,03Fh        ; the read-from-a-file function for int 21h
    mov bx,0           ; the file handle for standard input
    mov cx,0FFh        ; maximum number of bytes to read
    mov dx,textbuf     ; address of buffer to read into
    int 021h           ; call on Good Old Dos
    mov [text_len],ax  ; returns number of bytes actually read in ax
                       ; store it for future use

         ; now we've got some text, lets write it to a file

    mov ah,03Ch        ; the open/create-a-file function
    mov cx,020h        ; file attribute - normal file
    mov dx,filename    ; address of a ZERO TERMINATED! filename string
    int 021h           ; call on Good Old Dos
    mov [filehndl],ax  ; returns a file handle (probably 5)

    mov ah,040h        ; the Write-to-a-file function for int 21h
    mov bx,[filehndl]  ; the file handle goes in bx
    mov cx,[text_len]  ; number of bytes to write
    mov dx,textbuf     ; address to write from (the text we input)
    int 021h           ; call on Good Old Dos

    mov ah,03Eh        ; the close-the-file function
    mov bx,[filehndl]  ; the file handle
    int 021h           ; call on Good Old Dos

           ; pause and wait for a keystroke before continuing
    xor ax,ax
    int 016h           ; call BIOS - wait for a key

           ; read the file back into a buffer

    mov ah,03Dh        ; the open-existing-file function
    mov al,0           ; open mode 0=read,1=write,2=both
    mov dx,filename    ; address of zero-terminated string
    int 021h           ; call on Good Old Dos
    mov [filehndl],ax  ; we'll reuse the filehndl variable,
                       ; but use a different one if you open
                       ; more than one :)
    mov ah,03Fh        ; the read-from-a-file function
    mov bx,[filehndl]  ; our new (same as old, probably) file handle
    mov cx,0FFh        ; max bytes to read
    mov dx,iobuf       ; address of a buffer to read into
    int 021h           ; call on Good Old Dos
    mov [read_len],ax  ; save the number of bytes read

    mov ah,03Eh        ; close the file
    mov bx,[filehndl]  ; yeah, file handle in bx
    int 021h           ; call on Good Old Dos

           ; and write it out to already-open standard output

    mov ah,040h        ; write-to-a-file
    mov bx,1           ; file handle for standard output
    mov cx,[read_len]  ; bytes to write - same number we read :)
    mov dx,iobuf       ; buffer to write from
    int 021h           ; call on Good Old Dos

exit:
   mov ah,04Ch         ; terminate-program function
   int 021h            ; you guessed it!

;--------------------------------------------------
section .data
    msg db 'Please enter some text...',0Dh,0Ah
    msg_len dw $-msg  ; let assembler count it...
    filename db 'testtext.txt',0
;--------------------------------------------------
section .bss
    textbuf resb 0100h
    iobuf resb 0100h
    text_len resw 01h
    read_len resw 01h
    filehndl resw 01h



