MAXCODES equ 0FFFh                   ;4095
MAXXDOTS equ 320

[org 0100h]

[section .data]
filename db 'test.gif',0
;filerrmsg db 'File Error!',00h,'$'

[section .bss]
uninit:
initcodesize resw 01h
currcodesize resw 01h
clrcode resw 01h
endcode resw 01h
slot resw 01h
top_slot resw 01h
firstcode resw 01h
nbits_left resw 01h
old_code resw 01h
out_value resw 01h

c resw 01h
i resw 01h
j resw 01h
b1 resb 01h
fastloop resw 01h

dsp resw 01h
bufptr resw 01h
bufcnt resw 01h

code resw 01h
decoderline resb MAXXDOTS+1                  ;  screen width
dstack resb MAXCODES+1
sizeofstring resw MAXCODES+01h
prefix resw MAXCODES+1                ; note that prefix is words
suffix resb MAXCODES+1                ; but suffix is bytes

outln resw 01h                        ; pointer to output-a-line process

scrwidth resw 01h
scrheight resw 01h
scrcolors resw 01h

linestart resw 01h

filbuf resb 08000h
zzz:
[section .text]
    mov cx,zzz                 ; clear uninit'ed data space
    sub cx,uninit
    xor ax,ax
    mov di,uninit
    rep stosb

    mov si,filename                   ; open "test.gif"
    mov dx,0001h                      ; open if it exists
    xor bx,bx                         ; open for read
    mov ax,06C00h                     ; open\create
    int 021h                          ; dos - better be 4.0+ - better work!
    mov bx,ax                       ; file handle
    mov cx,08000h                   ; read 32k bytes
    mov dx,filbuf                    ; to buffer
    mov ah,03Fh
    int 021h
                                ; check for errors! close it?
    mov si,filbuf
    add si,06h             ; six characters in "GIF8?a"
                           ; check here if it _is_ a gif
    lodsw                 ; width
    mov [scrwidth],ax
    lodsw                 ; height
    lodsb                       ; planes + color map flag
    mov cl,al
    test cl,080h
    jnz okcolormap
    jmp exit      ;fileerror            ; we're expecting a color map!
okcolormap:
    mov ax,01h
    and cl,0Fh
    inc cl                           ; planes
    shl ax,cl                        ; numcolors
    mov [scrcolors],ax

    lodsw            ; ????  89a interlace flag + stuff?

    ; 768 dacbox                ; set up palette

    mov ax,013h
    int 010h
    call SETPAL
    mov word[outln],GR19OUTLN

    add si,0300h


getblocktype:
    lodsb                     ; , ! : etc. - block type
    cmp al,';'                ; ; end of block - we're done?
    jne checkforext
    jmp exit
checkforext:
    cmp al,'!'                ; ! extended info block - dump it
    jne checkforimg
    lodsb                     ; extended block id - ignore
    lodsb                     ;    "       "   length
    sub ah,ah
    mov cx,ax
    rep lodsb                 ; just dump the data
    jmp getblocktype
checkforimg:
    cmp al,','                    ; start of image block
    je imgblock
    jmp exit                ; unknown block type - we're lost!

imgblock:
    lodsw                  ; top
    lodsw                  ; left
    lodsw                  ; width
    lodsw                  ; height
    lodsb                ; local map flag + planes
    test al,080h
    jz nolocalmap
    or al,0Fh                ; skip local map here, if any
    mov cl,al
    inc cl                   ; planes
    mov ax,01h
    shl ax,cl                ; number of colors
    mov cx,03h
    mul cx
    mov cx,ax
    rep lodsb                ; junk the palette
nolocalmap:
                                        ;decoder
    xor ax,ax
    lodsb             ; initcodesize
    mov [initcodesize],ax      ; initial code size
    inc al             ; currcodesize
    mov [currcodesize],ax
    mov cx,ax
    mov ax,01h
    shl ax,cl          ; top_slot
    mov [top_slot],ax
    mov cx,[initcodesize]
    mov ax,01h
    shl ax,cl          ; clear
    mov [clrcode],ax
    inc ax             ; endcode
    mov [endcode],ax
    inc ax             ; slot, firstcode
    mov [slot],ax
    mov [firstcode],ax
                         ; un-sub-block the data in place
    push si
    mov di,si
getsubblocksize:
    lodsb             ; available bytes in this sub-block
    cmp al,00h
    jz allunblocked
    sub ah,ah
    mov cx,ax
rep movsb
    jmp getsubblocksize
allunblocked:
    pop si

    mov     word [dsp],dstack         ; initialize dsp
    mov     word[bufptr],decoderline      ; " bufptr
    mov     ax,WORD[scrwidth]      ;linewidth
    mov     WORD[bufcnt],ax      ;bufcnt

getcodes:
    call    get_next_code
    mov word[c],ax             ; save code as c
    cmp ax,[endcode]            ; if endcode we must be done
    jne check4clear
    jmp exit               ; end code found - exit decoder
check4clear:
        mov     ax,WORD [clrcode]     ;clear
        cmp     WORD [c],ax     ;c
        jne     notclear                             ; do the clearcode

        mov     ax,WORD[firstcode]     ;firstcode
        mov     WORD[slot],ax      ;slot
	mov	bx,ax
	shl	bx,1
        mov     WORD [sizeofstring+bx],00h
        mov     cx,WORD[initcodesize]     ;size
	inc	cx
        mov     WORD[currcodesize],cx
        mov     ax,01h
	shl	ax,cl
        mov     WORD[top_slot],ax     ;top_slot
getmorecodes:
        call    get_next_code
        mov     WORD[c],ax     ;c
        cmp     ax,WORD[clrcode]     ;clear
        je      getmorecodes
        mov     ax,WORD[endcode]     ;endcode
        cmp     WORD[c],ax     ;c
        jne notendcode            ; endcodefound - must be done
        jmp exit
notendcode:
                    ; check for code>slot
        mov     ax,WORD[c]     ;c
        mov     WORD[old_code],ax     ;old_code
        mov     BYTE[out_value],al     ;out_value
        mov     bx,WORD[dsp]     ;dsp
        inc     WORD[dsp]        ;dsp
        mov     BYTE[bx],al      ; push it on dstack
        jmp     checkstack
notclear:
        mov     ax,WORD[c]     ;c
        mov     WORD[code],ax     ;code
        cmp     ax,WORD[slot]      ;slot
        jl      codeunderslot
        jle     codeequslot
        mov     ax,WORD[slot]      ; if c>slot - bad code, fake it
        mov     WORD[c],ax         ; c=slot
codeequslot:                                ; code == slot  -  fastloop ends
        mov     ax,WORD[old_code]     ;old_code
        mov     WORD[code],ax     ;code
        mov     al,BYTE[out_value]     ;out_value
        mov     bx,WORD[dsp]     ;dsp
        inc     WORD[dsp]        ;dsp
        mov     BYTE[bx],al      ; stack the out_value
codeunderslot:                                ; code < slot  -  fastloop ends
        mov     WORD[fastloop],0      ;
        jmp     slowloop
qwikloop:
	mov	bx,ax
	shl	bx,1
        mov     ax,WORD[sizeofstring+bx]
        mov     WORD[i],ax     ;i
        mov     WORD[j],ax     ;j
	or	ax,ax
        jg      sosok
        jmp     stacksuffix
sosok:
        sub     ax,WORD[bufcnt]      ;bufcnt
	neg	ax
	or	ax,ax
 jg bufcntok
 jmp stacksuffix
bufcntok:
        mov     WORD[fastloop],-1     ;fastloop
whilej:
        mov     bx,WORD[code]     ;code
        mov     al,BYTE[suffix+bx]
        mov     bx,WORD[bufptr]      ;bufptr
    add bx,word[j]
    mov byte[bx],al               ; store direct to output buffer
        mov     bx,WORD[code]     ;code
	shl	bx,1
        mov     ax,WORD[prefix+bx]
        mov     WORD[code],ax     ;code
        dec     WORD[j]        ;j
        jg      whilej

        mov     al,BYTE[code]     ;code
        mov     bx,WORD[bufptr]      ;bufptr
        mov     BYTE[bx],al
        inc     WORD[i]        ;i
        mov     ax,WORD[i]     ;i
        add     WORD[bufptr],ax      ;bufptr
        sub     WORD[bufcnt],ax      ;bufcnt
        jne     slowloop
        mov     ax,WORD[bufptr]      ;bufptr
        sub     ax,decoderline
   push si                        ; save pointer into filbuf
   mov si,decoderline
        call    WORD[outln]
   pop si                   ; restore pointer into filbuf
        mov     WORD[bufptr],decoderline      ;bufptr
        mov     ax,WORD[scrwidth]      ;linewidth
        mov     WORD[bufcnt],ax      ;bufcnt
        jmp     SHORT slowloop
stacksuffix:
        mov     bx,WORD[code]     ;code
        mov     al,BYTE[suffix+bx]
   push si
        mov     si,WORD[dsp]     ;dsp
        inc     WORD[dsp]        ;dsp
        mov     BYTE[si],al      ; write suffix of code to output stack
    pop si
	shl	bx,1
        mov     ax,WORD[prefix+bx]
        mov     WORD[code],ax     ;code
slowloop:
        mov     ax,WORD[code]     ;code
        cmp     WORD[firstcode],ax     ;firstcode
        jg      codeoverfirstcode
        jmp     qwikloop
codeoverfirstcode:
        cmp     WORD[fastloop],0      ;fastloop
        jne     isfast
        mov     al,BYTE[code]     ;code
        mov     bx,WORD[dsp]     ;dsp
        inc     WORD[dsp]        ;dsp
        mov     BYTE[bx],al      ; put code on dstack
isfast:
        mov     ax,WORD[top_slot]     ;top_slot
        cmp     WORD[slot],ax      ;slot
        jge     bumpsize
        mov     bx,WORD[old_code]     ;old_code
	shl	bx,1
        mov     ax,WORD[sizeofstring+bx]
	inc	ax
        mov     bx,WORD[slot]      ;slot
	shl	bx,1
        mov     WORD[sizeofstring+bx],ax
        mov     al,BYTE[code]     ;code
        mov     BYTE[out_value],al     ;out_value
   push si
        mov     si,WORD[slot]      ;slot
        mov     BYTE[suffix+si],al
    pop si
        mov     ax,WORD[old_code]     ;old_code
        mov     WORD[prefix+bx],ax
        inc     WORD[slot] ;slot
        mov     ax,WORD[c]     ;c
        mov     WORD[old_code],ax     ;old_code
bumpsize:
        mov     ax,WORD[top_slot]     ;top_slot
        cmp     WORD[slot],ax      ;slot
        jl      checkstack
        cmp     WORD[currcodesize],12
        jge     checkstack
        shl     WORD[top_slot],1      ;top_slot
        inc     WORD[currcodesize]
checkstack:
        cmp     WORD[dsp],dstack  ;dsp
        ja      morestack
        jmp     getcodes
morestack:
        dec     WORD[dsp]        ;dsp
        mov     bx,WORD[dsp]     ;dsp
        mov     al,BYTE[bx]          ; get decoded byte off dstack
        mov     bx,WORD[bufptr]
        inc     WORD [bufptr]
        mov     BYTE [bx],al         ; put it in output buffer
        dec     WORD[bufcnt] ;bufcnt
        jne     checkstack           ; more room in output buffer?
        mov     ax,WORD[bufptr]      ; no - dump it to screen
        sub     ax,decoderline       ; how many 
    push si
        mov     si,decoderline       ; where
        call    WORD [outln]
    pop si
        mov     WORD[bufptr],decoderline      ; re-init bufptr
        mov     ax,WORD[scrwidth]
        mov     WORD [bufcnt],ax           ; and bufcnt
        jmp     SHORT checkstack
                                      ; end of decoder

exit:
    xor ax,ax
    int 016h                  ; pause while we admire our handiwork
    mov ax,0003h
    int 010h
    mov ah,04Ch
    int 021h


;------------------------------------------------
; si->768 byte palette buffer
SETPAL
    push ax
    push bx
    push cx
    push dx
    push si

    xor bx,bx
setmore:
    lodsb
    shr al,02h
    mov dh,al
    lodsb
    shr al,02h
    mov ch,al
    lodsb
    shr al,02h
    mov cl,al
    mov ax,01010h
    int 010h
    inc bx
    cmp bx,0100h
    jne setmore

    pop si
    pop dx
    pop cx
    pop bx
    pop ax
    ret
;------------------------------------------------



;-----------------------------------------------
get_next_code  ; PROC NEAR

        cmp     WORD[nbits_left],0
        jne     bitsleft
      lodsb
        mov     BYTE[b1],al
        mov     WORD[nbits_left],8
bitsleft:
	mov	cl,8
        sub     cl,BYTE[nbits_left]
        mov     al,BYTE[b1]
	shr	al,cl
        sub     ah,ah
        mov     dx,ax
        jmp     SHORT checkifdone
getbits:
   lodsb
        mov     BYTE[b1],al
        mov     cl,BYTE[nbits_left]
	sub	ah,ah
	shl	ax,cl
        or      dx,ax
        add     WORD[nbits_left],8
checkifdone:
        mov     ax,WORD[currcodesize]
        cmp     WORD[nbits_left],ax
        jl      getbits
        sub     WORD[nbits_left],ax
    mov cx,ax                       ; calculate mask
    mov ax,01h
    shl ax,cl
    dec ax
        and     ax,dx
	ret	
;----------------------------------------------

;-------------------------------------------

GR19OUTLN
push cx
push es
push di

mov cx,ax
mov ax,0A000h
mov es,ax
mov di,word[linestart]
add word[linestart],cx             ;0140h
rep movsb

pop di
pop es
pop cx
ret
;------------------------------------------------
