[org 0100h]
[section .data]
  alarmflag db 0
  msg db 'Alarm Went Off!',00h,'$'
[section .text]
  mov cx,0E4h                      ;
  mov dx,0E1C0h                    ; 15000000 microseconds
  mov bx,alarmflag                 ; es:bx points to byte flag
  mov ah,083h                      ; set bit 7 of flag after wait
  mov al,00h                       ; set the timer
  int 015h                         ;
  mov dl,'a'
wait4it:
  mov ah,01h                       ; so we can bail out...
  int 016h                         ;
  jz nokey
  xor ax,ax
  int 016h
  cmp al,01Bh
  jnz notesc
  jmp bailout
notesc:
                                   ; check for other keys here
nokey:
  mov ah,02h
  int 021h
  inc dl
  cmp dl,'z'
  jnz keepon
;  call BIDEAWEE
  mov cx,05h
  call tickdelay
  mov dl,'a'
keepon:
  test byte[alarmflag],080h        ; time up?
  jz wait4it
bailout:
  mov dx,msg
  mov ah,09h
  int 021h
  mov ah,04Ch
  int 021h

BIDEAWEE
  push ax
  push cx
  push dx

  mov cx,07h                    ; 03h
  mov dx,0A120h                 ; 0D090h
  mov ah,086h
  int 015h

  pop dx
  pop cx
  pop ax
  ret

; ===============================================
;  Delay function
;  Input:
;    CX = time to delay (in clock ticks)
; ===============================================

tickdelay
	push    ds
	push    ax
	push    cx
	mov     ax,64                   ; Timer segment
	mov     ds,ax
.loop   mov     al,[06Ch]               ; [64]
.wait
        cmp     al,[06Ch]              ; [64]
	je      .wait
	dec     cx
	jnz     .loop
	pop     cx
	pop     ax
	pop     ds
	ret
