; nasm -f bin -o nfact.com nfact.asm

[org 100h]
[segment .data]
    factmsg db ' factorial is ',0
    overmsg db 8,8,8,'overflows 64 bits!',0 ; 3 BS's to overwrite "is "
    newline db 0Dh,0Ah,0
[segment .bss]
    numbuf resb 080h   ; buffer for our number "conversion"

[segment .text]
    mov ecx,1          ; start with n=1
nextfact:
                       ; show n
    xor edx,edx        ; clear high dword - we don't want it
    mov eax,ecx        ; edx:eax = n
    mov di,numbuf      ; buffer for "conversion"
    call U64TODA       ; 64 bit number to string at di
    mov si,numbuf
    call PUTASCZ       ; show the string

    mov si,factmsg     ; show "!"
    call PUTASCZ
    
    mov eax,1          ; set up for mult loop
    push ecx           ; save our old n - loop will decrement ecx
factmult:
    mov ebx,eax        ; save old low dword
    mov eax,edx        ; multiply old high dword
    mul ecx            ; by n, n-1, n-2, etc
    or edx,edx         ; have we got a "too high" dword?
    jnz overflow       ; bail out if we do
    xchg ebx,eax       ; get old low dword back, stash new high dword
    mul ecx            ; multiply the low dword by n, n-1,...
    add edx,ebx        ; add high dword result to high dword from this mult
    jc overflow        ; does that put us over 64 bits?
    loop factmult      ; dec ecx (n) and repeat if not zero

                       ; show n!
    mov di,numbuf
    call U64TODA
    mov si,numbuf
    call PUTASCZ
    mov si,newline
    call PUTASCZ

    pop ecx               ; get our last n back
    inc ecx               ; bump it
    jmp nextfact          ; and do the next one

overflow:
    pop ecx            ; we had it saved on stack when we exited loop
    mov si,overmsg
    call PUTASCZ
    mov si,newline
    call PUTASCZ
                      ; can't return result as errorlevel
    mov al,cl         ; but we could say how many we did
    mov ah,04Ch
    int 021h


;--------------------------------------------------------------
; U64TODA - converts (64 bit) integer in edx:eax
; to (comma delimited) decimal representation in
; asciiz ( & "$") terminated string in buffer pointed to by di
;-----------------------------------------------------------------
U64TODA 
                push eax
                push ebx
                push ecx
                push edx
                push esi
                push edi
                mov ebx,edx     ; stash high dword
                mov esi,0Ah     ; prepare to divide by 10
                xor cx,cx       ; zero the digit count
                jmp highleft    ; check is high word 0 ?
highword:
                xchg eax,ebx    ; swap high & low words
                xor edx,edx     ; zero edx for the divide!
                div esi         ; divide high word by 10
                xchg eax,ebx    ; swap 'em back
                div esi         ; divide low word including remainder
                push edx        ; remainder is our digit - save it
                inc cx          ; count digits
highleft:
                or ebx,ebx
                jnz highword
lowleft:
                xor edx,edx          ; zero high word
                div esi              ; divide low word by 10
                push edx             ; our digit
                inc cx               ; count it
                or eax,eax           ; 0 yet ?
                jne lowleft
                cmp cx,04h           ; commas needed ?
                jl write2buf         ; nope
                xor dx,dx            ; zero high word for divide
                mov ax,cx            ; number of digits
                mov bx,3
                div bx
                mov si,dx            ; remainder = number digits before comma
                or dx,dx
                jnz write2buf        ; no remainder?
                mov si,3             ; we can write 3 digits, then.
write2buf:
                pop eax              ; get digit back - in right order
                add al,30H           ; convert to ascii character
                stosb                ; write it to our buffer
                dec si               ; digits before comma needed
                jnz moredigits       ; no comma needed yet
                cmp cx,2             ; we at the end?
                jl moredigits        ; don't need comma
                mov al,','           ; write a comma
                stosb
                mov si,03h           ; we're good for another 3 digits
moredigits:
                loop write2buf       ; write more digits - cx of 'em
                mov al,00h           ; terminate buffer with zero
                stosb
                mov al,'$'           ; and $ for int 21 subfn 9
                stosb
                pop edi
                pop esi
                pop edx
                pop ecx
                pop ebx
                pop eax
                ret
;-------------------------------------------------------------


;-----------------------------------------------
PUTASCZ
  push ax
  push si
ptz1:
  lodsb
  cmp al,00h
  jz ptz2
  call CHAROUT
  jmp ptz1
ptz2:
  pop si
  pop ax
  ret
;--------------------------------------------------------------

;-------------------------------------------------
; dos stdout version
CHAROUT
  push ax
  push dx
  mov dl,al
  mov ah,02h
  int 021h
  pop dx
  pop ax
  ret
;-------------------------------------------------------

