; assemble with "nasm -f bin -o probs5.com probs5.asm

%include "keyequ2.inc"    ; "names" for keys like "up arrow"
org 100h

segment .text

    call problem1  ; looks almost high level, from up here!
    call problem2
    call problem3
    call problem4
    call problem5
exit:
    mov ah,4Ch
    int 21h
;----------------------------------------------------

;----------------------------------------------------
problem1
    mov ah,2Ah       ; dos get-the-date function
    int 21h
    mov [curr_year],cx
    mov [curr_month],dh
    mov byte[curr_month+1],0
    mov [curr_day],dl
    mov byte[curr_day+1],0

prob1start:
    call print_following_message
    db 'Please enter your date of birth. Year first.',0Dh,0Ah
    db 'Please enter a Four Digit Year: ',0
    xor si,si     ; no default string to USRSTR
    mov cx,4      ; max len to get
    mov di,numbuf ; buffer to put it
    call USRSTR   ; fancy input routine
    cmp al,1Bh    ; user hit escape?
    jnz noescape1
    jmp prob1exit
noescape1:
    cmp cx,4      ; USRSTR returns chars got in cx
    jz prob1gotyear
    call print_following_message
    db 0Dh,0Ah,'Pay Attention! Four Digits!',0Dh,0Ah
    db 'The world was nearly brought to an end by the likes of you.'
    db 0Dh,0Ah,0
    jmp prob1start
prob1gotyear:          ; we've got four digits, anyway
    mov si,numbuf      ; buffer holding string
    call ATOL          ; convert string at si to number in dx:ax
    jc prob1oops       ; returns carry set if non-numeric data 
    mov bx,[curr_year]
    sub bx,150         ; nobody's older than that (?)
    cmp ax,bx
    jnc prob1yearok
prob1oops:
    call print_following_message
    db 0Dh,0Ah,'You claim to be born when?',0Dh,0Ah,0
    jmp prob1start
prob1yearok:
    cmp [curr_year],ax
    jnc prob1yearok2
    call print_following_message
    db 0Dh,0Ah,"You haven't been born yet!",0Dh,0Ah,0
    jmp prob1start
prob1yearok2:           ; guess it's a valid year
    mov [user_year],ax
prob1getmonth:
    call print_following_message
    db 0Dh,0Ah,'Month (1-12)? ',0
    xor si,si     ; no default string to USRSTR
    mov cx,2      ; max len to get
    mov di,numbuf ; buffer for input
    call USRSTR   ; get input from victim
    cmp al,1Bh
    jnz noescape2
    jmp prob1exit
noescape2:
    mov si,numbuf  ; buffer holds string
    call ATOL
    jc prob1badmonth
    cmp ax,13
    jnc prob1badmonth
    or ax,ax   ; this just sets the flags without changing ax
    je prob1badmonth
    jmp prob1gotmonth
prob1badmonth:
    call print_following_message
    db 0Dh,0Ah,'Please re-enter ',0
    jmp prob1getmonth
prob1gotmonth:
    mov [user_month],ax
prob1getday
    call print_following_message
    db 0Dh,0Ah,'Day of the month (1-31)? ',0
    xor si,si     ; no default string to USRSTR
    mov cx,2      ; max len to get
    mov di,numbuf
    call USRSTR
    cmp al,1Bh
    jnz noescape3
    jmp prob1exit
noescape3:
    mov si,numbuf
    call ATOL
    jc prob1badday
    cmp ax,32
    jnc prob1badday
    or ax,ax
    je prob1badday
    jmp prob1gotday
prob1badday:
    call print_following_message
    db 0Dh,0Ah,'Shape up, Earthing! ',0
    jmp prob1getday
prob1gotday:
    mov [user_day],ax
    mov ax,[curr_year]
    sub ax,[user_year]
    mov bx,[curr_month]
    sub bx,[user_month]
    jnz prob1skipday
    mov bx,[curr_day]
    sub bx,[user_day]
    jnz prob1skipday
    call print_following_message
    db 0Dh,0Ah,'Happy Birthday!',0
    jmp prob1gotage
prob1skipday:
    jnc prob1gotage
    dec ax
prob1gotage:
    xor dx,dx
    mov di,numbuf
    call LTOA
    call print_following_message
    db 0Dh,0Ah,'You are ',0
    mov si,numbuf
    call PUTASCZ
    call print_following_message
    db " years old. That's over ",0
    mov bx,ax
    mov dx,[seconds_in_year+2]
    mul dx
    xchg ax,bx
    mov dx,[seconds_in_year]
    mul dx
    add dx,bx

    mov di,numbuf
    call LTOA
    mov si,numbuf
    call PUTASCZ
    call print_following_message
    db ' seconds!',0Dh,0Ah,0

prob1exit:
    ret
;-----------------------------------------------------

;----------------------------------------------------
problem2

prob2getft:
    call print_following_message
    db 0Dh,0Ah,'Please enter your height in feet and inches. '
    db 0Dh,0Ah,'Feet: ',0
    mov cx,1
    xor si,si
    mov di,numbuf
    call USRSTR
    cmp al,1Bh
    jnz noescape4
    jmp prob2exit
noescape4:
    mov si,numbuf
    call ATOL
    jnc prob2gotft
    call print_following_message
    db 0Dh,0Ah,'Invalid input. Please try again.',0Dh,0Ah,0
    jmp prob2getft
prob2gotft:
    mov [user_ht_ft],ax
prob2getin:
    call print_following_message
    db 0Dh,0Ah,'Inches: ',0
    mov cx,2
    xor si,si
    mov di,numbuf
    call USRSTR
    cmp al,1Bh
    jnz noescape5
    jmp prob2exit
noescape5:
    mov si,numbuf
    call ATOL
    jnc prob2gotin
    call print_following_message
    db 0Dh,0Ah,'Invalid input. Please try again.',0Dh,0Ah,0
    jmp prob2getin
prob2gotin:
    mov [user_ht_in],ax
    call print_following_message
    db 0Dh,0Ah,'Your height is ',0

    fld qword[inches_per_foot]
    fild word[user_ht_in]
    fdiv st1
    fild word [user_ht_ft]
    fadd st1
    mov di,numbuf   ; buffer to store converted string
    mov dh,2        ; decimal places
    mov dl,5        ; length - including sign and decimal point
    call FTOA
    call PUTASCZ
    call print_following_message
    db ' feet.',0Dh,0Ah,0

prob2exit:
    ret
;--------------------------------------------------------
    
;--------------------------------------------------------
problem3
    call print_following_message
    db 0Dh,0Ah,'Enter your full name (Firstname Lastname): ',0
    mov cx,40h        ; max chars to get
    mov si,defaultname  ; show a default string
    mov di, ascbuf    ; buffer for input
    call USRSTR
    cmp al,ESC
    jnz noescape6
    jmp prob3exit
noescape6:
    call print_following_message
    db 0Dh,0Ah,'Name: ',0

    xor cx,cx          ; clear cx for count of first name
    mov si,ascbuf      ; buffer is our source
prob3scan:
    inc cx             ; count chars in first name
    lodsb              ; load al from source ([si]), inc si
    cmp al,' '         ; find end of first name?
    jnz prob3scan      ; no - keep looking
    call PUTASCZ       ; rest is last name - print it
    mov al,','         ; and a comma
    call [putcmethod]  ; this just calls dos int 21h/2
    mov al,' '         ; print a space
    call [putcmethod]
    mov si,ascbuf      ; back up to firstname
prob3lput:
    lodsb
    call [putcmethod]
    loop prob3lput      ; print cx characters
prob3exit:
    ret
;--------------------------------------------------


;-------------------------------------------------
problem4
    call print_following_message
    db 0Dh,0Ah,'Any key for 20 Cubes',0Dh,0Ah,0
    call [getcmethod]   ; get (wait for) a key - calls bios
    cmp al,ESC
    jne noescape11
    jmp prob4exit
noescape11:
    mov cx,20           ; load loop counter - why stop at 6?
tocube:
    xor dx,dx           ; clear dx - ltoa uses it
    mov ax,cx           ; use loop counter as operand
    mov di,numbuf       ; buffer for result
    call LTOA           ; convert to ascii
    mov si,numbuf       ; point to it
    call PUTASCZ        ; and print it
    call print_following_message
    db ' cubed is ',0
    call cubecx     ; cubes the number in cx - result in dx:ax
    mov di,numbuf   ; buffer for string
    call LTOA       ; convert dx:ax to string
    mov si,numbuf   ; point to it
    call PUTASCZ    ; and show it
    call print_following_message
    db 0Dh,0Ah,0    ; CR/LF
    loop tocube     ; do another
prob4exit:
    ret
;---------------
cubecx:
    push cx      ; save cx - they're using it upstairs
    mov ax,cx    ; copy it to ax - operand for "mul"
    mov bx,cx    ; copy to bx - operand for "mul"
    mov cx,2     ; use it for loop counter
cubeloop:
    mul bx
    loop cubeloop   ; two "mul bx"s - pretty short loop
    pop cx       ; restore caller's loop counter
    ret

;----------------------------------------------------

;----------------------------------------------------
problem5
    fld qword[inches_per_foot]  ; re-calculate decimal
    fild word[user_ht_in]       ; height - we didn't save it
    fdiv st1
    fild word [user_ht_ft]
    fadd st1

    call print_following_message
    db 0Dh,0Ah,'We know your height and age.',0Dh,0Ah
    db 'Better tell us your gender (M/F): ',0
prob5get:
    call [getcmethod]  ; get a key
    and al,0DFh        ; force it to uppercase
    cmp al,'M'
    je male
    cmp al,'F'
    je female
    cmp al,ESC
    jne prob5get      ; none of the above - get another
    call print_following_message   ; user declines
    db 0Dh,0Ah,"It's been PC!",0Dh,0Ah,0
    jmp prob5exit
male:
    fld qword[male_avg_ht]
    jmp prob5calc
female:
    fld qword[fem_avg_ht]
prob5calc:
    mov [user_gender],al
    call print_following_message
    db 0Dh,0Ah,'You are ',0
    fcompp
    fstsw ax    ; good grief, is this the only way to check the
    sahf        ; FPU flags? I cribbed this bit from Prof. Hyde!
    je average
    jnc shorter
    call print_following_message
    db 'taller than ',0
    jmp average
shorter:
    call print_following_message
    db 'shorter than ',0
average:
    call print_following_message
    db 'average height, ',0
    cmp byte[user_gender],'M'
    je nomaam
    call print_following_message
    db 'Madam.',0Dh,0Ah,0
    jmp prob5exit
nomaam:
    call print_following_message
    db 'Sir.',0Dh,0Ah,0

prob5exit:
    ret
;-----------------------------------------------------

;-----------------------------------------------------
; FTOA - converts floating point to string
;
; Based on some code "sponged" from a post to clax 
; From: "Jim Morrison" <astrolabe at ntplx dot net>
;
; Expects: Number to convert is on stack top
;          di points to buffer to store string
;          dh = Decimal Places,
;          dl = Total Length, including sign and decimal point.
; Returns si points to beginning of zero-terminated,
;            right justified (per dl) string - not necessarily
;            beginning of buffer
;-------------------------------------------------------------

FTOA:
    push ax
    push bx
    push cx
    push dx
    push di

    xor cx,cx            ; clear cx
    add di,19            ; point to end of string area
    mov byte[di+1],0     ; start by terminating string!
    push di              ; end of string area
    mov cl,dh            ; decimal places to loop
    or cl,cl             ; if no decimal (integer)
    je f2a2              ; skip multiply by ten loop
f2a1:                    ; else loop to "scale" number
    fimul word[TEN]
    loop f2a1
f2a2:
    fbstp [bcdbuf]       ; convert to bcd and store
    mov si,bcdbuf        ; we'll pull digits from there
    finit                ; reset the fpu
    mov cl,dl            ; total length to convert
f2a3:
    cld                  ; "up" flag to load from bcdbuf
    lodsb                ; get a pair of digits
    mov ah,al            ; move a copy to ah
    shr ah,4             ; shift out low nibble, keeping high
    and ax,0F0Fh         ; mask out the digits we want
    add ax,3030h         ; convert 'em both to ascii
    std                  ; "down"  flag to store in string buffer
    stosb                ; store it "backwards" in buffer
    loop f2a4            ; we're doing two per "real" loop
    jmp f2a5             ; done - do sign
f2a4:
    mov al,ah            ; swap and store the other digit
    stosb
    loop f2a3            ; until done
f2a5:
    cmp byte[bcdbuf+9],0 ; sign flag at bcdbuf + 9 ?
    mov al,' '            ; assume positive
    je f2a6
    mov al,'-'            ; minus sign if we need it
f2a6:
    stosb                 ; store it at front of our string
    cld                   ; direction flag back "up"
                          ; di now points a byte before beginning
    or dh,dh              ; any decimal places?
    jne f2a7              ; yep- go put it in!
    inc di                ; else point to sign
    mov bx,di             ; bx points to sign, too
    jmp f2a8             ; commence stripping leading zeros
f2a7:                     ; place the decimal point
    mov cl,dl             ; total length
    sub cl,dh             ; less decimal places
    inc cx                ; bytes to move
    mov bx,di             ; save pointer to just-before-sign
    mov si,di             ; use it for source
    inc si                ; but now it points to sign
    rep movsb             ; shift "whole" part left to make room for
    mov al,'.'            ; decimal point
    stosb                 ; and store it
f2a8:                    ; strip leading zeros
    mov al,[bx]           ; save the sign (' ' or '-')
    mov ah,' '            ; space to replace zeros with
f2a9:
    cmp byte[bx+1],'0'    ; next character a zero?
    jne f2a10             ; nope, we're done
    cmp byte[bx+2],'.'    ; if next char after that is decimal point
    je f2a10              ; leave one zero
    mov [bx],ah           ; else replace it with space
    inc bx                ; and go check next character
    jmp f2a9
f2a10:
    mov [bx],al           ; replace the sign char
    pop si                ; restore pointer to end of string
    cmp byte[si],' '      ; in the event the number was 0
    jne f2a11             ; all zeros were removed above
    mov byte[si],'0'      ; so put one back
f2a11:
    mov dh,0              ; now dx is total length
    sub si,dx             ; subtract it to point before first char
    inc si                ; and to first char, ready for the PUTASCZ call
    pop di
    pop dx
    pop cx
    pop bx
    pop ax

    ret
;--------------------------------------------------


;----------------------------------------------------------
; output zero-terminated string pointed
; to by (ds:)si, via [putcmethod]
; returns - nothing: all registers preserved 
;---------------------------------------------------------
PUTASCZ ; proc
  push ax
  push si
ptz1:
  lodsb
  cmp al,00h
  jz ptz2
  call [putcmethod]
  jmp ptz1
ptz2:
  pop si
  pop ax
  ret
;--------------------------------------------------------------

;-------------------------------------------------
; dos stdout version
;-------------------------------------------------
CHAROUT
  push dx
  mov dl,al
  mov ah,02h
  int 021h
  pop dx
  ret
;--------------------end CHAROUT------------------------


;-------------------------------------------------------
; based on code sponged from David Lindauer's GRDB code
; http://www.ladsoft.com
; Expects: to be called like
;    call print_following_message
;    db 'blablabla',0
;    do *not* neglect to zero-terminate the message!
;
; Returns: this version trashes si, but runs on anything.
;          Uncomment the "xchg si,[esp]" and comment out the
;          'pop si" and "push si" for a 386+ version that
;          leaves si alone.
;---------------------------------------------------------
print_following_message
    ;xchg si,[esp]
    pop si
    push ax
pfm1:
    mov al,[cs:si]
    inc si
    or al,al
    jz pfm2
    call [putcmethod]
    jmp pfm1
pfm2:
    pop ax
    push si
    ;xchg si,[esp]
    ret
;----------------------------------------------------------

;-----------------------------------------------------------
; ATOL converts ascii number at si to dx:ax
; returns NC, or CY on error (some character not a decimal digit)
;----------------------------------------------------------
ATOL
    push bx
    push cx
    push si
    push di

    xor ax,ax
    xor bx,bx
    xor dx,dx
atolnext:
    mov bl,[si]              ; get another digit
    inc si
    cmp bl,00h               ; end of string?
    jz atoldone
    cmp bl,','               ; ignore commas
    jz atolnext
    cmp bl,'9'
    ja atolnot
    sub bl,030h
    jc atolnot

    mov di,dx                ; borrow di - stash old total high word
    mov cx,0Ah               ; 10 decimal
    mul cx                   ; old total low word * 10
    xchg dx,cx               ; cx hi word, dx = 10 dec
    xchg ax,di               ; now di stashes new total lo word
    mul dx                   ; old high word * 10
    jc atolnot               ; we've overrun 4G
    mov dx,ax                ; dx new hi word
    mov ax,di                ; lo word back in ax 
    add ax,bx                ; add in new digit
    adc dx,cx                ; add in any overflow from lo * 10 and any carry

    jmp atolnext          ; get another char

atolnot:
    stc
    jmp atolret
atoldone:
    clc
atolret:
    pop di
    pop si
    pop cx
    pop bx
    ret
;ATOL endp;------------------------------------

;--------------------------------------------------------------
; LTOA - converts long (32 bit) integer in dx:ax to (comma delimited)
;        asciiz ( & "$") terminated string in buffer pointed to by di
;-----------------------------------------------------------------
LTOA ; PROC NEAR
                push ax
                push bx
                push cx
                push dx
                push si
                push di
                mov bx,dx
                mov si,0Ah            ; divide by 10
                xor cx,cx
                jmp highleft          ; is high word 0 ?
highword:
                xchg ax,bx           ; swap high & low words
                xor dx,dx            ; zero dx for remainder
                div si               ; divide high word by 10
                xchg ax,bx           ; swap 'em back
                div si               ; divide low word including remainder
                push dx              ; remainder is our digit
                inc cx               ; count digits
highleft:
                or bx,bx
                jnz highword
lowleft:
                xor dx,dx            ; zero high word
                div si               ; divide low word by 10
                push dx              ; our digit
                inc cx               ; count it
                or ax,ax             ; 0 yet ?
                jne lowleft
                cmp cx,04h           ; commas needed ?
                jl write2buf         ; nope
                xor dx,dx            ; zero high word for divide
                mov ax,cx            ; number of digits
                mov bx,3
                div bx
                mov si,dx            ; remainder = number digits before comma
                or dx,dx
                jnz write2buf        ; no remainder?
                mov si,3             ; we can write 3 digits, then.
write2buf:
                pop ax               ; get digit
                add ax,30H           ; convert to ascii character
                stosb                ; write it to our buffer
                dec si
                jnz moredigits
                cmp cx,2
                jl moredigits
                mov al,','           ; write a comma
                stosb
                mov si,03h           ; we're good for another 3 digits
moredigits:
                loop write2buf       ; write more digits
                mov al,00h           ; terminate buffer with zero
                stosb
                mov al,'$'           ; and $ for int 21 subfn 9
                stosb
                pop di
                pop si
                pop dx
                pop cx
                pop bx
                pop ax
                ret
; LTOA ENDP
;-------------------------------------------------------------


;--------------------------------------------------------------------
; USRSTR - gets a string from user via [getcmethod]
; expects: SI=default string or SI=0 - default better fit in buffer!
;          DI=buffer to receive string - better be big enough!
;          CX= max length to get - not including terminating 0!
;          [usrstrcmds] - zero terminated word array of keys to
;                         be returned for direct handling by caller
;                         should include ESC, FFFF (error) if likely,
;                         F1 (help), UP, DN, PGUP, PGDN, TAB, etc,
;                         may be included and handled according to
;                         the needs of the caller.
;                         RIGHT, LEFT, INSERT, DEL, HOME, ENDK,
;                         BS, and ENTERK are handled internally,
;                         and should NOT be included.
; calls:   [getcursmethod], [setcursmethod], PUTASCZ,
;          [putcmethod], [getcmethod]
;          these can be changed to get from stdio, bios, remote, etc.
; returns: SI points to zero terminated string
;          AX=last key pressed (check for ESC, error)
;          CX=length gotten (not including 0)
;          BP,BX,DX preserved
;          DI points past terminating zero
;-------------------------------------------------------------------

USRSTR
  push bp                  ; save caller's bp,bx,dx
  push bx                        
  push dx
  push di                  ; save input buffer address (popped to si)
  push cx                  ; save max len (to be restored in di)
  call [getcursmethod]     ; returns row:col in dx, size in cx
  xor bx,bx                ; current position,
  xor bp,bp                ; length, start at 0
  cmp si,00h               ; we don't have a default string?
  jz nodef
moredef:                   ; copy default string to inbuf
  inc bx                   ; bump position
  inc bp                   ; bump length
  lodsb
  stosb
  cmp al,00h
  jnz moredef
  dec bx
  dec bp
  pop di                   ; di=max length to get
  pop si                   ; si = inbuf
  jmp firstkey             ; commence input
nodef:
  pop di                   ; di=max length to get
  pop si                   ; si = input buffer
  mov byte[si],00h         ; terminate the (null) string
  jmp nextkey              ; commence input
firstkey:         ; special input for first char (if default string)
  call [setcursmethod]     ; (to "home" position)
  call PUTASCZ             ; show default string
  call [getcmethod]
  cmp al,'\'               ; assume backslash intended to be added
  je notfirst              ; don't erase default
  cmp al,021h              ; assume space intended to be added
  jl notfirst              ; don't erase default
                    ; erase the default - we don't want it
  push ax                  ; save our character
  call [setcursmethod]     ; start at "home" position
  mov al,' '               ; put spaces
erase:
  call [putcmethod]
  dec bx
  jne erase                ; ... for entire length
  mov byte[si],00h         ; terminate the (null) string
  call [setcursmethod]     ; back to "home" position
  xor bp,bp                ; position, length back to 0
  pop ax                   ; restore the character
  jmp notfirst             ; treat character as normal input
nextkey:                   ; main input loop
  call [setcursmethod]     ; to "home" position
  call PUTASCZ             ; show what we've got so far
  mov al,' '               ; put a space - in case we're backing up
  call [putcmethod]        ; (this space isn't part of our string)
  push dx                  ; save our "home" position
  add dl,bl                ; adjust column
  call [setcursmethod]     ; to input position
  pop dx                   ; restore "home" position
  call [getcmethod]
notfirst:                  ; "first key" routine rejoins us here
  push bx                  ; save position
  mov bx,[usrstrcmds]      ; check the extra commands list
usrchkcmds:
  cmp word[bx],00h         ; end of list?
  jz usrcmdnotfound
  cmp ax,[bx]              ; whole word match?
  jz usrcmdfound
  cmp byte[bx],00h         ; an "extended" key?
  jz usrcmdnotext          ; if it was, no match
  cmp al,[bx]              ; low byte match?
  jz usrcmdfound
usrcmdnotext:
  inc bx                   ; nope, try next in list
  inc bx
  jmp usrchkcmds
usrcmdfound:
  pop bx                   ; restore position
  jmp usrstrdun            ; let caller handle extra command
usrcmdnotfound:
  pop bx                   ; restore position
usrokay:                   ; check for "our" commands
  cmp al,00h               ; is it an extended/editing key?
  jnz usrstrascii          ; nope - check "regular" keys
  cmp ax,LEFT              ; check  editing keys
  jnz usnotleft
  cmp bx,00h               ; are we at beginning of string? - ignore
  jz nextkey
  dec bx                   ; else move position left
  jmp nextkey
usnotleft:
  cmp ax,RIGHT
  jnz usnotright
  cmp bp,bx                ; are we at end of string? - ignore
  jz nextkey
  inc bx                   ; else move position right
  jmp nextkey
usnotright:
  cmp ax,HOME
  jnz usnothome
  xor bx,bx                ; position 0
  jmp nextkey
usnothome:
  cmp ax,ENDK
  jnz usrnotendk
  mov bx,bp                ; position is at end of string
  jmp nextkey
usrnotendk:
  cmp ax,INSERT
  jnz usnotins
  xor cx,01D00h            ; toggle cursor size (bit 15 is overwrite mode)
  jmp nextkey
usnotins:
  cmp ax, DEL
  jnz usnotdel
  cmp bx,bp                ; end of string? - ignore
  jnz usrdragleft          ; use the "backspace" code 
  jmp nextkey
usnotdel:
  jmp nextkey              ; an editing key, but not one we want

usrstrascii:               ; check regular ascii keys
  cmp al,BS
  jnz usnotbs
  cmp bx,00h               ; beginning of string? ignore
  jnz usrbsok
  jmp nextkey
usrbsok:
  dec bx                  ; move position back
usrdragleft:              ; entry point for "delete" routine
  dec bp                  ; shorten length
  push bx                 ; save position
usdrag:
  mov al,[si+bx+1]        ; character from "next" position
  mov [si+bx],al          ; goes in "current" position
  inc bx                  ; cook
  cmp al,00h              ; 'til done
  jnz usdrag
  pop bx                  ; restore position
  jmp nextkey
usnotbs:
  cmp al,ENTERK           ; must think we have our string!
  jz usrstrdun            ; else must be a real addition to our string
  cmp bp,bx               ; end of string?
  jnz usrmidstr           ; nope - do middle of string routine
  inc bp                  ; yep - increase length
  cmp di,bp               ; check for overflow (di= max to get)
  jae usrstradd           ; we're ok - add it
overflow:
  dec bp                  ; put length back to safe level
  mov al,BEEPK            ; toot the damn speaker
  call [putcmethod]
  jmp nextkey             ; and ignore the input
usrmidstr:                ; middle of string routine
  test cx,01000h          ; insert mode?
  jnz usrstradd           ; no - just do it
                          ; make a space for our character
  inc bp                  ; bump length
  cmp di,bp               ; check for overflow
  jb overflow             ; beep and ignore
  push ax                 ; save the character
  push bp                 ; save length
  xchg bx,bp              ; swap length, position
usrpushrt:                ; push right from position to end
  mov al,[si+bx-1]        ; character in "previous" position
  mov [si+bx],al          ; goes in "current" position
  dec bx                  ; move back to previous character
  cmp bx,bp               ; 'til we reach the "real" input position
  jnz usrpushrt
  xchg bx,bp              ; swap length,position back
  pop bp                  ; restore the length
  pop ax                  ; restore the character
usrstradd:                ; put a character in our string - finally!
  mov byte[si+bx],al      ; put our character there
  xchg bx,bp
  mov byte[si+bx],00h     ; terminate string (needed if EOS, no harm)
  xchg bx,bp
  inc bx                  ; increase input position
  jmp nextkey             ; get more
usrstrdun:                ; routine terminated by enter or extra cmd
  mov cx,0707h            ; restore "normal" cursor
  call [setcursmethod]
  mov cx,bp               ; return length in cx
  mov di,si               ; beginning of buffer
  add di,cx               ; plus length
  inc di                  ; di points past terminating zero
  pop dx                  ; restore caller's dx
  pop bx                  ;    "       "     bx
  pop bp                  ;    "       "     bp
  ret                     ; if we ain't got it, we ain't gonna
; USRSTR endp
;----------------------------------------------------------------------

;-------------------------------------------------------
WAIT4CHAR
;  xor ax,ax ; XT compatible - doesnt get cntrl-up, etc.
  mov ax,010h ; AT compatible
  int 016h
  ret
; WAIT4CHAR endp
;----------------------------------------------------------

;----------------------------------------------------------
SETCURSOR
  push ax
  push bx
  mov ah,01h                     ; set cursor to size in cx
  mov bh,00h                     ; video page zero
  int 010h                       
  mov ah,02h                     ; set cursor position to dx (row:column)
  int 010h
  pop bx
  pop ax
  ret
; SETCURSOR endp
;---------------------------------------------------------

;--------------------------------------------------------
GETCURSOR
  push ax
  push bx
  mov ah,03h                     ; set cursor position,size
  mov bh,00h                     ; video page zero
  int 010h                       ; cursor pos in dx - size in cx
  pop bx
  pop ax
  ret
; GETCURSOR endp
;--------------------------------------------------------------

segment .data
    inches_per_foot dq 12.0
    seconds_in_year dd 31557600
    TEN dw 10   ; multiplier for the float-to-ascii routine

    male_avg_ht dq 5.75    ; fix these numbers
    fem_avg_ht dq 5.5      ; I haven't the least idea

    putcmethod dw  CHAROUT     ; for the PUTASCZ routine
    getcmethod dw WAIT4CHAR     ; for the USRSTR routine
    getcursmethod dw GETCURSOR      ; "
    setcursmethod dw SETCURSOR      ; "
    usrnormcmd dw 001Bh,0FFFFh,00h  ; "
    usrstrcmds dw usrnormcmd        ;"extra" keys - ESC and error

    defaultname db 'World! Hello',0 ; show off my default string

segment .bss

    ascbuf resb 80h  ; buffer for user i/o
    numbuf resb 020h ; buffer for our result string
    bcdbuf resb 0Ah  ; ten byte scratch area for the float-to-ascii routine

    curr_year resw 1
    curr_month resw 1
    curr_day resw 1
    user_year resw 1
    user_month resw 1
    user_day resw 1
    user_ht_ft resw 1
    user_ht_in resw 1
    user_gender resb 1

