[org 0100h]
[segment .data]
textrctab db 02h,03h,014h              ; normal 80 x 25
          ; <-40 column-> <-80 column->
          db 00h,01h,014h,00h,03h,014h   ; 12 rows
          db 00h,01h,011h,00h,03h,011h   ; 14 rows
          db 01h,01h,014h,01h,03h,014h   ; 21 rows
          db 02h,01h,014h,02h,03h,014h   ; 25 rows
          db 01h,01h,011h,01h,03h,011h   ; 25 rows
          db 00h,01h,012h,00h,03h,012h   ; 25 rows
          db 02h,01h,011h,02h,03h,011h   ; 28 rows
          db 01h,01h,012h,01h,03h,012h   ; 43 rows
          db 02h,01h,012h,02h,03h,012h   ; 50 rows
;             ^   ^   ^        ^ 80 column mode (normal)
;             |   |   | font 11= 8 x 14, 12= 8 x 8, 14= 8 x 16
;             |   | 40 column mode
;             | scan lines 0= 200, 1= 350, 2= 400

msg db 'Here is some text.',0,'$'

[segment .text]
  mov ax,01h
testtable:
  push ax
  call SETTEXTRC
  mov dx,msg
  mov ah,09h
  int 021h
  xor ax,ax
  int 016h
  pop ax
  inc ax
  cmp ax,012h
  jbe testtable
  xor ax,ax
  call SETTEXTRC
  mov ah,04Ch
  int 021

;--------------------------------------------------------
; SETTEXTRC - sets text rows/columns to table entry
; expects: ax=number of table entry 0=normal 25 x 80
;           1 - 12 x 40     2 - 12 x 80
;           3 - 14 x 40     4 - 14 x 80
;           ....
;           17 - 50 x 40    18 - 50 x 80
; returns: ax=0 for success, else FFFFh (bad call or not supported)
;--------------------------------------------------------
SETTEXTRC
  push bx
  push si
  cmp ax,012h                     ; sanity check on call
  ja badexit
  mov bx,03h                      ; each table entry is 3 bytes
  mul bx                          ; table entry number in ax X 3
  mov si,textrctab                ; start of table
  add si,ax                       ; point to our entry
  lodsb                           ; get the scanline code
  mov ah,012h                     ; various ega/vga functions
  mov bl,030h                     ; select "set scan lines" function
  int 010h                        ; call bios video services
  cmp al,012h                     ; function supported code
  jne badexit                     ; coincidence - same as table count
  lodsb                           ; get the video mode number
  mov ah,00h                      ; set mode function
  int 010h                        ; set it
  lodsb                           ; get the font code
  mov ah,011h                     ; char generator function
  int 010h                        ; set it
  cmp al,012h                     ; function supported?
  jne badexit                     ; should be if 1st one was.
  xor ax,ax                       ; return success
  jmp exit
badexit:
  mov ax,0FFFFh                   ; return error
exit:
  pop si
  pop bx
  ret
;--------------------------------------------------------
