org 0100h

segment .data
               ; message in char,attrib,char,attrib... format
    msg1 db 'M',01h,'a',02h,'n',03h,'y',04h,' ',05h,'T',06h
         db 'h',07h,'a',08h,'n',09h,'k',0Ah,'s',0Bh,' ',0Ch
         db 't',0Dh,'o',0Eh,' ',0Fh,'R',01h,'a',02h,'l',03h
         db 'f',04h,' ',05h,'B',06h,'r',07h,'o',08h,'w',09h
         db 'n',0Ah,'!',0Bh      ; no need to terminate...
    msg1len dw $-msg1            ; let the assembler count 'em!

segment .text

    mov ax,0003h     ; reset video mode to 3 (cheesy CLS)
    int 010h         ; call bios video services
domore:
    mov bp,msg1      ; point to string
    mov cx,[msg1len] ; length of string - chars + attributes
    shr cx,01h       ; div by two to get char-only len for the call
    mov dh,0bh       ; row
    mov dl,01Ah      ; column
    mov bh,00h       ; video page "usually" (?) zero
                     ; don't care what BL is for this AL
    mov ah,013h      ; write string in ES:BP at DH,DL (row,column)
    mov al, 02h      ; char, attr,... format - no cursor update 
                     ; 3 - char,attrib - update  cursor
                     ; 1 - attrib in BL - update cursor
                     ; 0 - attrib in BL - no update
    int 010h         ; call video services (AT+,EGA+ ???)
                     ; rather than alter the pallette, we just
    mov bx,msg1      ; change the colors in the string, and
    mov cx,[msg1len] ; reprint it (no cursor update :) ! )
    shr cx,01h       ; number of colors
morecolors:
    inc bx           ; skip over character
    mov al,[bx]      ; get current color
    inc al           ; bump it
    cmp al,010h      ; we only change low nibble - high nibble
    jnz colorok      ; is background (bit 7 set - FG blinks)
    mov al,01h       ; we don't want color zero (black), or we
colorok:             ; could just "or al,0Fh"
    mov [bx],al      ; stuff it back in the string
    inc bx           ; point to next character
    loop morecolors  ; do 'em all
    mov cx,02h       ; BIOS is "slow", but we still
    call DELAYCX     ; need some delay
    mov ah,01h       ; check keyboard status
    int 016h
    jz domore        ; no key hit - do it again
    mov ah,00h       ; get the key off the buffer
    int 016h
                     ; could clearscreen again here, but
exit:                ; naw, let's leave it...
    mov ah,04ch      ; scram
    int 021h

;----------------------------------------------------------
; twiddle thumbs for cx/18.2 seconds
DELAYCX
        push ax
        push bx
        push    ds
        mov     bx,0040h       ; BIOS data segment
        mov     ds,bx
        mov     bx,6Ch         ; BIOS timer, 40:6C
        mov     ax,[bx]
        add ax,cx
DelayLoop:
        cmp     ax,[bx]        ; Is it the same?
        jnc      DelayLoop     ; No, try again.
        pop     ds             ; Restore registers and exit.
        pop bx
        pop ax
        ret
;------------------------------------------------------------------

