;--------------------------------------------
; today.asm - prints the date to standard output
;
; Assemble with "nasm -f bin -o today.com today.asm"
;     or "nasm today.asm"/"ren today today.com", if
;     you don't like switches :) 
; No (hardly any) directives or macros. In DEBUG,
; P(roceed) into the int 1AH - don't T(race)
;------------------------------------------------

org 100h        ; *must* tell Nasm we're a com file!
                ; we *really* ought to declare this as 
; segment .text ; a code segment, but Nasm will default
                ; to the right thing - 16-bit code.

    jmp overdata   ; we could avoid this nonsense by
                ; putting uninitialized data in a
                ; "segment .bss" ("segment .data" for
                ; initialized data), as God and Simon
                ; intended! Directives ain't *that* scary!

    datestring times 0Eh db 0 ; make *sure* it's big enough!

overdata:     ; just a label to jump to - needed only because
              ; no segment directives are used.
          ; Now our real code starts...
    mov ah,4    ; interrupt service routine to get the date
    int 1Ah     ; see Ralf Brown or helppc for info.

    mov di,datestring   ; address in our "destination index"

    mov al,dh     ; int 1Ah returns month in dh
    call byte2hex ; our routine to put a hex representation
                  ; of al into an ascii string at di
    mov al,'-'    ; put a "dash" in our string
    stosb         ; stores al to [di] ([es:di], actually)
                  ; and increments di to point to next position
    mov al,dl     ; day is in dl - add it to our string.
    call byte2hex ; Actually, int 1Ah returns info in BCD,
                  ; "Binary Coded Decimal" format, but
                  ; displaying it as hexadecimal works OK.
    mov al,'-'    ; another dash - you could use '/' or '.'
    stosb         ; mov [es:di],al / inc di ...
    mov ax,cx     ; year is in cx
    call word2hex ; convert an entire word (16 bits) this time.
    mov al,'$'    ; damfool dollar-sign for dos int 21h/9
    stosb         ; to terminate our string.
           ; we're ready to display our masterpiece...
    mov dx,datestring
    mov ah,9      ; just like Hello World...
    int 21h

    mov ah,4Ch    ; go bye-bye
    int 21h
;-----------------------------------------------------------------


;------------------------------------------------------
; sponged From: qscgz at aol dawt com (QSCGZ)
; word2hex - call with word in ax
;            or as byte2hex with byte in al
; buffer in di,if you like - rets unterminated string!
; trashes ax,bx
;------------------------------------------------------

word2hex:
    mov bx,ax         ; save a copy of the original
    shr ax,12         ; move first nybble into position
    call nyb2hex      ; convert and add/display
    mov ax,bx         ; restore original value
    shr ax,8          ; next nybble into position
    call nyb2hex      ; etc.
    mov ax,bx
byte2hex:
    mov bx,ax   ; redundant in the "word2hex" call ...
    shr ax,4
    call nyb2hex
    mov ax,bx
nyb2hex:
    and al,0Fh    ; mask off low ("rightmost") nybble
    cmp al,10     ; if it's past the 0-9 range, we need
                  ; to "bump it up" to A-F
;    sbb al,105   ; this "tricky" code does the same
;    das          ; conversion as the following
                  ; "naive" version - "best"???
    jc okdigit    ; ok if it's 0-9, if its 10-15,
    add al,7      ; adjust it to A-F. (not, with BCD)
okdigit:
    add al,30h    ; and convert to ascii character

;    int 029h     ; display now,
    stosb         ; or add to string
    ret           ; return to where we were called from -
                  ; back into this function if "nyb2hex" was
                  ; called - back to original caller if we
                  ; "fell through" to nyb2hex
;---------------------------------------------------------

