[org 100h]
%include "keyequ.inc"
[segment .data]
  defmsg db 'default',0h
  testmsg db 0Dh,0Ah,'you typed:  ',00h
  escmsg db 0Dh,0Ah,'You hit Escape.',00h
  errmsg db 0dh,0Ah,'An input error occured!',0Dh,0Ah,00h
  defwasmsg db 0Dh,0Ah,'Default string was: ',00h
  beforemsg db 'Received before error: ',00h
[segment .bss]
  inbuf resb 080h

[segment .text]
;  mov si,defmsg                 ; default msg
  mov si,00h                   ; ...or not
  mov di,inbuf                  ; input buffer better be big enough!
  mov cx,010h                   ; max length (including terminating 0 !!!)
  call USRSTR
  cmp ax,0FFFFh                 ; error might be returned by remote CHK4CHAR
  jnz noerror                   ; unlikely from keyboard
                       ; do what you will with it
  mov si,errmsg
  call PUTASCZ
  mov si,beforemsg
  call PUTASCZ
  mov si,inbuf
  call PUTASCZ
  mov si,defwasmsg
  call PUTASCZ
  mov si,defmsg                   ; not if there wasn't one!
  call PUTASCZ
  jmp egress
noerror:
  cmp al,ESC                      ; user bail out?
  jnz goodinput                   ; must be okay
                        ; do what you will - copy default, recall?
  mov si,escmsg                   ; we'll just report and quit
  call PUTASCZ
  mov si,defwasmsg
  call PUTASCZ
  mov si,defmsg
  call PUTASCZ
goodinput:
  call CRLF
  mov si,inbuf
  call ATOL
  jc egress
  mov di,inbuf
  call LTOA
  call PUTASCZ
egress:
  mov ah,04Ch
  int 021h

;--------------------------------------------------------------------
; USRSTR - gets a string from user via CHK4CHAR
; expects: SI=default string or SI=0 - default better fit in buffer!
;          DI=buffer to receive string - better be big enough!
;          CX= max length to get - including terminating 0
; calls:   GETCURSOR, SETCURSOR, PUTASCZ, CHAROUT, CHK4CHAR
;          these can be changed to get from stdio, bios, remote, etc.
; returns: SI points to zero terminated string
;          AX=last key pressed (check for ESC, error)
;          CX=length gotten (including 0)
;          BX,DX preserved
;          DI destroyed
;-------------------------------------------------------------------

USRSTR
  push bx                        ; save caller's bx,dx
  push dx
  push di                        ; save input buffer address (popped to si)
  xchg cl,ch                     ; get max len in high byte
  push cx                        ; save max len (to be restored in di)
  call GETCURSOR                 ; row:col in dx, size in cx
  xor bx,bx                      ; position, length start at 0
  cmp si,00h                     ; we don't have a default string
  jz nodef
moredef:                         ; copy default string to inbuf
  inc bl                         ; bump position
  inc bh                         ; bump length
  lodsb
  stosb
  cmp al,00h
  jnz moredef
  dec bh
  dec bl
  pop di                         ; di=max length in high byte
  pop si                         ; si = inbuf
  jmp firstkey                   ; commence input
nodef:
  pop di                         ; di=max length in high byte
  pop si                         ; si = inbuf
  mov byte[si],00h               ; terminate the (null) string
  jmp nextkey                    ; commence input
firstkey:                  ; special input for first char (if default string)
  call SETCURSOR                ; (to "home" position)
  call PUTASCZ                  ; show default string
  call CHK4CHAR
  cmp ax,0FFFFh
  jnz usrok
  jmp usrstrdun
usrok:
  cmp al,'\'                    ; assume backslash intended to be added
  je notfirst                   ; don't erase default
  cmp al,021h                   ; assume space intended to be added
  jl notfirst                   ; don't erase default
                       ; erase the default - we don't want it
  push ax                       ; save our character
  call SETCURSOR                ; start at "home" position
  mov al,' '                    ; put spaces
erase:
  call CHAROUT
  dec bh
  jne erase                     ; ... for entire length
  mov byte[si],00h              ; terminate the (null) string
  call SETCURSOR                ; back to "home"
  xor bx,bx                     ; position, length back to 0
  pop ax                        ; restore the character
  jmp notfirst                  ; treat character as normal input
nextkey:                        ; main input loop
  call SETCURSOR                ; to "home" position
  call PUTASCZ                  ; show what we've got so far
  mov al,' '                    ; put a space - in case we're backing up
  call CHAROUT                  ; (this space isn't part of our string)
  push dx                       ; save our "home" position
  add dl,bl                     ; adjust
  call SETCURSOR                ; to input position
  pop dx                        ; restore "home" position
  call CHK4CHAR
notfirst:                       ; entry point for "first key" routine
  cmp ax,0FFFFh
  jnz usrokay
  jmp usrstrdun
usrokay:
  
  cmp al,00h                    ; is it an extended/editing key?
  jnz usrstrascii               ; nope - check "regular" keys
                       ; check  editing keys
  cmp ah,LEFT
  jnz usnotleft
  cmp bl,00h                    ; are we at beginning of string? - ignore
  jz nextkey
  dec bl                        ; else move position left
  jmp nextkey
usnotleft:
  cmp ah,RIGHT
  jnz usnotright
  cmp bh,bl                      ; are we at end of string? - ignore
  jz nextkey
  inc bl                        ; else move position right
  jmp nextkey
usnotright:
  cmp ah,HOME
  jnz usnothome
  xor bl,bl                     ; position 0
  jmp nextkey
usnothome:
  cmp ah,ENDK
  jnz usrnotendk
  mov bl,bh                     ; position is at end of string
  jmp nextkey
usrnotendk:
  cmp ah,INSERT
  jnz usnotins
  xor cx,01D00h               ; toggle cursor size (bit 15 is overwrite mode)
  jmp nextkey
usnotins:
  cmp ah, DEL
  jnz usnotdel
  cmp bl,bh                   ; end of string? - ignore
  jnz usrdragleft             ; use the "backspace" code 
  jmp nextkey
usnotdel:
                    ; might want to support UP, DN, PGDN, F1, etc.
  jmp nextkey                     ; an editing key, but not one we want
usrstrascii:                      ; check regular ascii keys
  cmp al,BS
  jnz usnotbs
  cmp bl,00h                      ; beginning of string? ignore
  jz nextkey
  dec bl                          ; move position back
usrdragleft:                      ; entry point for "delete" routine
  dec bh                          ; shorten length
  push bx                         ; save length:position
  and bx,00FFh                    ; get just position
usdrag:
  mov al,[si+bx+1]                ; character from "next" position
  mov [si+bx],al                  ; goes in "current" position
  inc bx                          ; cook
  cmp al,00h                      ; 'til done
  jnz usdrag
  pop bx                          ; restore length:position
  jmp nextkey
usnotbs:
  cmp al,ESC                      ; just quit - let caller deal with it
  jz usrstrdun
  cmp al,ENTERK                   ; must think we have our string!
  jz usrstrdun
                       ; must be a real addition to our string
  cmp bh,bl                       ; end of string?
  jnz usrmidstr                   ; nope - do middle of string routine
  inc bh                          ; yep - increase length
  cmp di,bx                       ; check for overflow (di= max in high byte)
  jae usrstradd                   ; we're ok - add it
overflow:
  dec bh                          ; put length back to safe level
  mov al,BEEPK                    ; toot the damn speaker
  call CHAROUT
  jmp nextkey                     ; and ignore the input
usrmidstr:                        ; middle of string routine
  test cx,01000h                  ; insert mode?
  jnz usrstradd                   ; no - just do it
                       ; make a space for our character
  inc bh                          ; bump length
  cmp di,bx                       ; check for overflow
  jb overflow                     ; beep and ignore
  push ax                         ; save the character
  push bx                         ; save length:position
usrpushrt:                        ; push from position to end right
  push bx                         ; save pseudo length:position
  mov bl,bh                       ; get just length
  and bx,00FFh
  mov al,[si+bx-1]                ; character in "previous" position
  mov [si+bx],al                  ; goes in "current" position
  pop bx                          ; restore pseudo length:position
  dec bh                          ; move back to previous character
  cmp bl,bh                       ; 'til we reach the "real" input position
  jnz usrpushrt
  pop bx                          ; restore the "real" length:position
  pop ax                          ; restore the character
usrstradd:                        ; put a character in our string - finally!
  push bx                         ; save length:position
  and bx,00FFh                    ; get just position
  mov byte[si+bx],al              ; put our character there
  pop bx                          ; restore length:position
  push bx                         ; save length:position
  mov bl,bh                       ; get just length
  and bx,00FFh
  mov byte[si+bx],00h             ; terminate string (needed if EOS, no harm)
  pop bx                          ; restore length:position
  inc bl                          ; increase input position
  jmp nextkey                     ; get more
usrstrdun:                        ; routine terminated by esc/enter
  mov cx,0707h                    ; restore "normal" cursor
  call SETCURSOR
  mov bl,bh                       ; whoopie! don't have to save it!
  and bx,0FFh                     ; get just length
  mov cx,bx                       ; return it in cx
  pop dx                          ; restore caller's dx
  pop bx                          ;    "       "     bx
  ret                             ; if we ain't got it, we ain't gonna
; USRSTR endp
;----------------------------------------------------------------------

;-----------------------------------------------------------
; ATOL converts ascii number at si to dx:ax
; returns NC, or CY on error (some character not a decimal digit)
;----------------------------------------------------------
ATOL
    push bx
    push cx
    push si
    push di

    xor ax,ax
    xor bx,bx
    xor dx,dx
atolnext:
    mov bl,[si]              ; get another digit
    inc si
    cmp bl,00h               ; end of string?
    jz atoldone
    cmp bl,','               ; ignore commas
    jz atolnext
    cmp bl,'9'
    ja atolnot
    sub bl,030h
    jc atolnot

    mov di,dx                ; borrow di - stash old total high word
    mov cx,0Ah               ; 10 decimal
    mul cx                   ; old total low word * 10
    xchg dx,cx               ; cx hi word, dx = 10 dec
    xchg ax,di               ; now di stashes new total lo word
    mul dx                   ; old high word * 10
    jc atolnot               ; we've overrun 4G
    mov dx,ax                ; dx new hi word
    mov ax,di                ; lo word back in ax 
    add ax,bx                ; add in new digit
    adc dx,cx                ; add in any overflow from lo * 10 and any carry

    jmp atolnext          ; get another char

atolnot:
    stc
    jmp atolret
atoldone:
    clc
atolret:
    pop di
    pop si
    pop cx
    pop bx
    ret
;ATOL endp;------------------------------------

;--------------------------------------------------------------
; LTOA - converts long (32 bit) integer in dx:ax to (comma delimited)
;        asciiz ( & "$") terminated string in buffer pointed to by di
;-----------------------------------------------------------------
LTOA ; PROC NEAR
                push ax
                push bx
                push cx
                push dx
                push si
                push di
                mov bx,dx
                mov si,0Ah            ; divide by 10
                xor cx,cx
                jmp highleft          ; is high word 0 ?
highword:
                xchg ax,bx           ; swap high & low words
                xor dx,dx            ; zero dx for remainder
                div si               ; divide high word by 10
                xchg ax,bx           ; swap 'em back
                div si               ; divide low word including remainder
                push dx              ; remainder is our digit
                inc cx               ; count digits
highleft:
                or bx,bx
                jnz highword
lowleft:
                xor dx,dx            ; zero high word
                div si               ; divide low word by 10
                push dx              ; our digit
                inc cx               ; count it
                or ax,ax             ; 0 yet ?
                jne lowleft
                cmp cx,04h           ; commas needed ?
                jl write2buf         ; nope
                xor dx,dx            ; zero high word for divide
                mov ax,cx            ; number of digits
                mov bx,3
                div bx
                mov si,dx            ; remainder = number digits before comma
                or dx,dx
                jnz write2buf        ; no remainder?
                mov si,3             ; we can write 3 digits, then.
write2buf:
                pop ax               ; get digit
                add ax,30H           ; convert to ascii character
                stosb                ; write it to our buffer
                dec si
                jnz moredigits
                cmp cx,2
                jl moredigits
                mov al,','           ; write a comma
                stosb
                mov si,03h           ; we're good for another 3 digits
moredigits:
                loop write2buf       ; write more digits
                mov al,00h           ; terminate buffer with zero
                stosb
                mov al,'$'           ; and $ for int 21 subfn 9
                stosb
                pop di
                pop si
                pop dx
                pop cx
                pop bx
                pop ax
                ret
; LTOA ENDP
;-------------------------------------------------------------


;-----------------------------------------------
PUTASCZ ; proc
  push ax
  push si
ptz1:
  lodsb
  cmp al,00h
  jz ptz2
  call CHAROUT
  jmp ptz1
ptz2:
  pop si
  pop ax
  ret
;--------------------------------------------------------------

;-------------------------------------------------
; dos stdout version
CHAROUT
  push dx
  mov dl,al
  mov ah,02h
  int 021h
  pop dx
  ret
; CHAROUT endp
;-------------------------------------------------------

;-------------------------------------------------------
CHK4CHAR
  xor ax,ax
  int 016h
  ret
; CHK4CHAR endp
;----------------------------------------------------------

;----------------------------------------------------------
SETCURSOR
  push ax
  push bx
  mov ah,01h                     ; set cursor to size in cx
  mov bh,00h                     ; video page zero
  int 010h                       
  mov ah,02h                     ; set cursor position to dx (row:column)
  int 010h
  pop bx
  pop ax
  ret
; SETCURSOR endp
;---------------------------------------------------------

;--------------------------------------------------------
GETCURSOR
  push ax
  push bx
  mov ah,03h                     ; set cursor position,size
  mov bh,00h                     ; video page zero
  int 010h                       ; cursor pos in dx - size in cx
  pop bx
  pop ax
  ret
; GETCURSOR endp
;--------------------------------------------------------------
; ----------------------------------------------------------
; prints a CR/LF pair to std out
; ------------------------------------------------------
CRLF ; proc
  push ax
  push dx
  mov al,0dh
  call CHAROUT
  mov al,0Ah
  call CHAROUT
  pop dx
  pop ax
  ret
;CRLF endp
; --------------------------end CRLF-----------------------
