[org 100h]
%include "keyequ2.inc"
MAXCMDLEN equ 050h
MAXMACROS equ 0Bh

segment .data

    defmsg db 'Default string',00h
    testmsg db '  You typed:  ',00h
    helpmsg db 0Dh,0Ah,'Heaven helps those who help themselves!',0Dh,0Ah,00h
    promptmsg db 'YouSez: ',00h
    macroaddmsg db 0Dh,0Ah,'Enter text for macro key: ',00h

    usrnormcmd dw 001Bh,0FFFFh,00h
    usrhistcmd dw 001Bh,0FFFFh,UP,DN
               dw F1,F2,F3,F4,F5,F6,F7,F8,F9,F10,F11,F12
                  ; note these are defines, not hex numbers!
               dw 0000h
    usrformcmd dw 001Bh,0FFFFh,UP,DN,TAB,PGDN,0000h

    getcmethod dw CHK4CHAR
    putcmethod dw CHAROUT
    getcursmethod dw GETCURSOR
    setcursmethod dw SETCURSOR
    helpmethod dw NODAMNHELP

    histnew dw histbuf
    histcurr dw histbuf
    histwrap dw histbuf

[segment .bss]

    usrstrcmds resw 01h
    inbuf resb 080h
    histbuf resb 0100h
histbufzzz:

uninit:

    macrokeybuf resb MAXCMDLEN * MAXMACROS

zzz:

[segment .text]

    mov cx,zzz                ; clear uninitialized memory
    sub cx,uninit
    sub al,al
    mov di,uninit
    rep stosb

    mov word[usrstrcmds],usrhistcmd  ; set up for input w/history
    mov word[histnew],histbuf
    mov word[histcurr],histbuf
gogetinput:
    mov si,promptmsg    ; show a prompt
    call PUTASCZ
    call HISTINPUT
    push si
    mov si,testmsg
    call PUTASCZ
    pop si
    call PUTASCZ
    call CRLF
    jmp gogetinput

error:
exit:
    mov ah,04Ch
    int 021h

;------------------------------------------------------
HISTINPUT
    mov si,00h          ; start with no default string
histin10:
    mov di,[histnew]   ; address to put input
    mov cx,MAXCMDLEN    ; length to get
    mov ax,histbufzzz   ; room for max length
    sub ax,di           ; before we hit end of buffer?
    cmp ax,cx
    jnc histin12        ; yup, get it
    mov [histwrap],di
    mov di,histbuf      ; start over at beginning
histin12:
    call USRSTR         ; try to get input
    cmp al,0Dh          ; "normal" return?
    jnz histin14        ; no, check "special" keys
    jmp histin60        ; yeah, we're done
histin14:
    cmp ax,0FFFFh       ; error? - well, not from keyboard
    jnz histin20        ; but maybe if getting from remote
    jmp error           ; do something intelligent
histin20:
    cmp al,ESC          ; customer hit escape?
    jnz histin30
    jmp exit            ; do something intelligent
histin30:
    cmp ax,UP           ; want previous command?
    jnz histin40
    mov si,[histwrap]   ; sanity check...
    cmp si,histbuf      ; was there a previous command?
    jnz histin301       ; yup
    xor si,si
    jmp histin10        ; no - re-prompt and re-get
histin301:
    mov si,[histcurr]
histin31:
    dec si
histin32:               ; back up to find previous
    cmp si,histbuf
    jnc histin34
    mov si,[histwrap]
    dec si
histin34:
    dec si
    cmp si,histbuf
    jz histin38
    cmp byte[si],00h
    jnz histin32
    inc si
histin38:
    mov [histcurr],si
    jmp histin10
histin40:                         ; not up-arrow, check down-arrow
    cmp ax,DN
    jnz histin50
    mov si,[histwrap]
    cmp si,histbuf
    jnz histin401
    xor si,si
    jmp histin10
histin401:
    mov si,[histcurr]
histin41:
    inc si
histin42:
    cmp si,[histwrap]
    jbe histin45
    mov si,histbuf
    jmp histin46
histin45:
    cmp byte[si],00h
    jnz histin41
    inc si
histin46:
    mov [histcurr],si
    jmp histin10
histin50:
    cmp ax,F1
    jnz histin51          ; check F1
    call [helpmethod]
    jmp histin10
histin51:                 ; check F2-F12 - macro keys
    cmp ax,F2
    jc histin52
    cmp ax,F12
    jnc histin52
    call DOMACROKEYS
    jmp histin10
histin52:
      ; shouldn't be here! is there some other key to check???
    jmp histin10
histin60:       ; command gotten - update pointers + go home
    cmp [histwrap],di
    jnc histin61
    mov [histwrap],di
histin61:
    mov word[histcurr],di
    mov [histnew],di

    ret
;---------------------------------------------------------

;---------------------------------------------------------
DOMACROKEYS
    sub ax,F2           ; which macro do we want (in high byte)
    shr ax,08h          ; shift it to low byte
    mov bx,MAXCMDLEN
    mul bx              ; offset into macro buffer
    mov bx,ax
    add bx,macrokeybuf
    cmp word[bx],00h    ; any macro set yet?
    jnz dmk1            ; yep - make it our default string
    mov si,macroaddmsg  ; nope - add a macro
    call PUTASCZ        ; show the prompt
    mov word[usrstrcmds],usrnormcmd  ; set up for a "plain" input
    xor si,si           ; no default
    mov di,bx           ; offset into macro buffer
    mov cx,MAXCMDLEN
    call USRSTR
                        ; check for error, ESC, etc???
    mov word[usrstrcmds],usrhistcmd  ; restore for "history" input
    jmp dmk2            ; and exit
dmk1:
    mov si,bx
dmk2:
    ret
;---------------------------------------------------------

;---------------------------------------------------------
NODAMNHELP
    push si
    mov si,helpmsg
    call PUTASCZ
    call CRLF
    pop si
    ret
;---------------------------------------------------------

;--------------------------------------------------------------------
; USRSTR - gets a string from user via [getcmethod]
; expects: SI=default string or SI=0 - default better fit in buffer!
;          DI=buffer to receive string - better be big enough!
;          CX= max length to get - not including terminating 0!
;          [usrstrcmds] - zero terminated word array of keys to
;                         be returned for direct handling by caller
;                         should include ESC, FFFF (error) if likely,
;                         F1 (help), UP, DN, PGUP, PGDN, TAB, etc,
;                         may be included and handled according to
;                         the needs of the caller.
;                         RIGHT, LEFT, INSERT, DEL, HOME, ENDK,
;                         BS, and ENTERK are handled internally,
;                         and should NOT be included.
; calls:   [getcursmethod], [setcursmethod], PUTASCZ,
;          [putcmethod], [getcmethod]
;          these can be changed to get from stdio, bios, remote, etc.
; returns: SI points to zero terminated string
;          AX=last key pressed (check for ESC, error)
;          CX=length gotten (including 0)
;          BP,BX,DX preserved
;          DI points past terminating zero
;-------------------------------------------------------------------

USRSTR
  push bp                  ; save caller's bp,bx,dx
  push bx                        
  push dx
  push di                  ; save input buffer address (popped to si)
  push cx                  ; save max len (to be restored in di)
  call [getcursmethod]     ; returns row:col in dx, size in cx
  xor bx,bx                ; current position,
  xor bp,bp                ; length, start at 0
  cmp si,00h               ; we don't have a default string?
  jz nodef
moredef:                   ; copy default string to inbuf
  inc bx                   ; bump position
  inc bp                   ; bump length
  lodsb
  stosb
  cmp al,00h
  jnz moredef
  dec bx
  dec bp
  pop di                   ; di=max length to get
  pop si                   ; si = inbuf
  jmp firstkey             ; commence input
nodef:
  pop di                   ; di=max length to get
  pop si                   ; si = input buffer
  mov byte[si],00h         ; terminate the (null) string
  jmp nextkey              ; commence input
firstkey:         ; special input for first char (if default string)
  call [setcursmethod]     ; (to "home" position)
  call PUTASCZ             ; show default string
  call [getcmethod]
  cmp al,'\'               ; assume backslash intended to be added
  je notfirst              ; don't erase default
  cmp al,021h              ; assume space intended to be added
  jl notfirst              ; don't erase default
                       ; erase the default - we don't want it
  push ax                  ; save our character
  call [setcursmethod]     ; start at "home" position
  mov al,' '               ; put spaces
erase:
  call [putcmethod]
  dec bx
  jne erase                ; ... for entire length
  mov byte[si],00h         ; terminate the (null) string
  call [setcursmethod]     ; back to "home" position
  xor bp,bp                ; position, length back to 0
  pop ax                   ; restore the character
  jmp notfirst             ; treat character as normal input
nextkey:                   ; main input loop
  call [setcursmethod]     ; to "home" position
  call PUTASCZ             ; show what we've got so far
  mov al,' '               ; put a space - in case we're backing up
  call [putcmethod]        ; (this space isn't part of our string)
  push dx                  ; save our "home" position
  add dl,bl                ; adjust column
  call [setcursmethod]     ; to input position
  pop dx                   ; restore "home" position
  call [getcmethod]
notfirst:                  ; "first key" routine rejoins us here
  push bx                  ; save position
  mov bx,[usrstrcmds]      ; check the extra commands list
usrchkcmds:
  cmp word[bx],00h         ; end of list?
  jz usrcmdnotfound
  cmp ax,[bx]              ; whole word match?
  jz usrcmdfound
  cmp byte[bx],00h         ; an "extended" key?
  jz usrcmdnotext          ; if it was, no match
  cmp al,[bx]              ; low byte match?
  jz usrcmdfound
usrcmdnotext:
  inc bx                   ; nope, try next in list
  jmp usrchkcmds
usrcmdfound:
  pop bx                   ; restore position
  jmp usrstrdun            ; let caller handle extra command
usrcmdnotfound:
  pop bx                   ; restore position
usrokay:                   ; check for "our" commands
  cmp al,00h               ; is it an extended/editing key?
  jnz usrstrascii          ; nope - check "regular" keys
  cmp ax,LEFT              ; check  editing keys
  jnz usnotleft
  cmp bx,00h               ; are we at beginning of string? - ignore
  jz nextkey
  dec bx                   ; else move position left
  jmp nextkey
usnotleft:
  cmp ax,RIGHT
  jnz usnotright
  cmp bp,bx                ; are we at end of string? - ignore
  jz nextkey
  inc bx                   ; else move position right
  jmp nextkey
usnotright:
  cmp ax,HOME
  jnz usnothome
  xor bx,bx                ; position 0
  jmp nextkey
usnothome:
  cmp ax,ENDK
  jnz usrnotendk
  mov bx,bp                ; position is at end of string
  jmp nextkey
usrnotendk:
  cmp ax,INSERT
  jnz usnotins
  xor cx,01D00h            ; toggle cursor size (bit 15 is overwrite mode)
  jmp nextkey
usnotins:
  cmp ax, DEL
  jnz usnotdel
  cmp bx,bp                ; end of string? - ignore
  jnz usrdragleft          ; use the "backspace" code 
  jmp nextkey
usnotdel:
  jmp nextkey              ; an editing key, but not one we want

usrstrascii:               ; check regular ascii keys
  cmp al,BS
  jnz usnotbs
  cmp bx,00h               ; beginning of string? ignore
  jnz usrbsok
  jmp nextkey
usrbsok:
  dec bx                  ; move position back
usrdragleft:              ; entry point for "delete" routine
  dec bp                  ; shorten length
  push bx                 ; save position
usdrag:
  mov al,[si+bx+1]        ; character from "next" position
  mov [si+bx],al          ; goes in "current" position
  inc bx                  ; cook
  cmp al,00h              ; 'til done
  jnz usdrag
  pop bx                  ; restore position
  jmp nextkey
usnotbs:
  cmp al,ENTERK           ; must think we have our string!
  jz usrstrdun            ; else must be a real addition to our string
  cmp bp,bx               ; end of string?
  jnz usrmidstr           ; nope - do middle of string routine
  inc bp                  ; yep - increase length
  cmp di,bp               ; check for overflow (di= max to get)
  jae usrstradd           ; we're ok - add it
overflow:
  dec bp                  ; put length back to safe level
  mov al,BEEPK            ; toot the damn speaker
  call [putcmethod]
  jmp nextkey             ; and ignore the input
usrmidstr:                ; middle of string routine
  test cx,01000h          ; insert mode?
  jnz usrstradd           ; no - just do it
                          ; make a space for our character
  inc bp                  ; bump length
  cmp di,bp               ; check for overflow
  jb overflow             ; beep and ignore
  push ax                 ; save the character
  push bp                 ; save length
  xchg bx,bp              ; swap length, position
usrpushrt:                ; push right from position to end
  mov al,[si+bx-1]        ; character in "previous" position
  mov [si+bx],al          ; goes in "current" position
  dec bx                  ; move back to previous character
  cmp bx,bp               ; 'til we reach the "real" input position
  jnz usrpushrt
  xchg bx,bp              ; swap length,position back
  pop bp                  ; restore the length
  pop ax                  ; restore the character
usrstradd:                ; put a character in our string - finally!
  mov byte[si+bx],al      ; put our character there
  xchg bx,bp
  mov byte[si+bx],00h     ; terminate string (needed if EOS, no harm)
  xchg bx,bp
  inc bx                  ; increase input position
  jmp nextkey             ; get more
usrstrdun:                ; routine terminated by enter or extra cmd
  mov cx,0707h            ; restore "normal" cursor
  call [setcursmethod]
  mov cx,bp               ; return length in cx
  mov di,si               ; beginning of buffer
  add di,cx               ; plus length
  inc di                  ; di points past terminating zero
  pop dx                  ; restore caller's dx
  pop bx                  ;    "       "     bx
  pop bp                  ;    "       "     bp
  ret                     ; if we ain't got it, we ain't gonna
; USRSTR endp
;----------------------------------------------------------------------

;----------------------------------------------------------
; output zero-terminated string pointed to by (ds:)si, via [putcmethod]
; returns - nothing: all registers preserved 
;---------------------------------------------------------
PUTASCZ ; proc
  push ax
  push si
ptz1:
  lodsb
  cmp al,00h
  jz ptz2
  call [putcmethod]
  jmp ptz1
ptz2:
  pop si
  pop ax
  ret
;--------------------------------------------------------------

;-------------------------------------------------
; dos stdout version
CHAROUT
  push dx
  mov dl,al
  mov ah,02h
  int 021h
  pop dx
  ret
; CHAROUT endp
;-------------------------------------------------------

;-------------------------------------------------------
CHK4CHAR
;  xor ax,ax ; XT compatible - doesnt get cntrl-up, etc.
  mov ax,010h ; AT compatible
  int 016h
  ret
; CHK4CHAR endp
;----------------------------------------------------------

;----------------------------------------------------------
SETCURSOR
  push ax
  push bx
  mov ah,01h                     ; set cursor to size in cx
  mov bh,00h                     ; video page zero
  int 010h                       
  mov ah,02h                     ; set cursor position to dx (row:column)
  int 010h
  pop bx
  pop ax
  ret
; SETCURSOR endp
;---------------------------------------------------------

;--------------------------------------------------------
GETCURSOR
  push ax
  push bx
  mov ah,03h                     ; set cursor position,size
  mov bh,00h                     ; video page zero
  int 010h                       ; cursor pos in dx - size in cx
  pop bx
  pop ax
  ret
; GETCURSOR endp
;--------------------------------------------------------------

; ----------------------------------------------------------
; prints a CR/LF pair via [putcmethod]
; ------------------------------------------------------
CRLF ; proc
  push ax
  push dx
  mov al,0dh
  call [putcmethod]
  mov al,0Ah
  call [putcmethod]
  pop dx
  pop ax
  ret
;CRLF endp
; --------------------------end CRLF-----------------------
