[org 100h]
%include "keyequ2.inc"

segment .data

    testmsg db '  You typed:  ',00h
    promptmsg db 'YouSez: ',00h
    usrnormcmd dw 001Bh,0FFFFh,00h

    getcmethod dw CHK4CHAR
    putcmethod dw CHAROUT
    getcursmethod dw GETCURSOR
    setcursmethod dw SETCURSOR

[segment .bss]

    usrstrcmds resw 01h
    inbuf resb 080h

[segment .text]

    mov si,promptmsg    ; show a prompt
    call PUTASCZ
    mov word[usrstrcmds],usrnormcmd  ;"extra" keys - ESC and error
    mov cx,080h                      ; get 128 max chars
    mov di,inbuf                     ; put 'em here
    xor si,si                        ; no "default" string
    call USRSTR                      ; get the string
    push si
    mov si,testmsg                   ; "process" it
    call PUTASCZ
    pop si
    call PUTASCZ
    call CRLF
error:
exit:
    mov ah,04Ch
    int 021h


;--------------------------------------------------------------------
; USRSTR - gets a string from user via [getcmethod]
; expects: SI=default string or SI=0 - default better fit in buffer!
;          DI=buffer to receive string - better be big enough!
;          CX= max length to get - not including terminating 0!
;          [usrstrcmds] - zero terminated word array of keys to
;                         be returned for direct handling by caller
;                         should include ESC, FFFF (error) if likely,
;                         F1 (help), UP, DN, PGUP, PGDN, TAB, etc,
;                         may be included and handled according to
;                         the needs of the caller.
;                         RIGHT, LEFT, INSERT, DEL, HOME, ENDK,
;                         BS, and ENTERK are handled internally,
;                         and should NOT be included.
; calls:   [getcursmethod], [setcursmethod], PUTASCZ,
;          [putcmethod], [getcmethod]
;          these can be changed to get from stdio, bios, remote, etc.
; returns: SI points to zero terminated string
;          AX=last key pressed (check for ESC, error)
;          CX=length gotten (not including 0)
;          BP,BX,DX preserved
;          DI points past terminating zero
;-------------------------------------------------------------------

USRSTR
  push bp                  ; save caller's bp,bx,dx
  push bx                        
  push dx
  push di                  ; save input buffer address (popped to si)
  push cx                  ; save max len (to be restored in di)
  call [getcursmethod]     ; returns row:col in dx, size in cx
  xor bx,bx                ; current position,
  xor bp,bp                ; length, start at 0
  cmp si,00h               ; we don't have a default string?
  jz nodef
moredef:                   ; copy default string to inbuf
  inc bx                   ; bump position
  inc bp                   ; bump length
  lodsb
  stosb
  cmp al,00h
  jnz moredef
  dec bx
  dec bp
  pop di                   ; di=max length to get
  pop si                   ; si = inbuf
  jmp firstkey             ; commence input
nodef:
  pop di                   ; di=max length to get
  pop si                   ; si = input buffer
  mov byte[si],00h         ; terminate the (null) string
  jmp nextkey              ; commence input
firstkey:         ; special input for first char (if default string)
  call [setcursmethod]     ; (to "home" position)
  call PUTASCZ             ; show default string
  call [getcmethod]
  cmp al,'\'               ; assume backslash intended to be added
  je notfirst              ; don't erase default
  cmp al,021h              ; assume space intended to be added
  jl notfirst              ; don't erase default
                    ; erase the default - we don't want it
  push ax                  ; save our character
  call [setcursmethod]     ; start at "home" position
  mov al,' '               ; put spaces
erase:
  call [putcmethod]
  dec bx
  jne erase                ; ... for entire length
  mov byte[si],00h         ; terminate the (null) string
  call [setcursmethod]     ; back to "home" position
  xor bp,bp                ; position, length back to 0
  pop ax                   ; restore the character
  jmp notfirst             ; treat character as normal input
nextkey:                   ; main input loop
  call [setcursmethod]     ; to "home" position
  call PUTASCZ             ; show what we've got so far
  mov al,' '               ; put a space - in case we're backing up
  call [putcmethod]        ; (this space isn't part of our string)
  push dx                  ; save our "home" position
  add dl,bl                ; adjust column
  call [setcursmethod]     ; to input position
  pop dx                   ; restore "home" position
  call [getcmethod]
notfirst:                  ; "first key" routine rejoins us here
  push bx                  ; save position
  mov bx,[usrstrcmds]      ; check the extra commands list
usrchkcmds:
  cmp word[bx],00h         ; end of list?
  jz usrcmdnotfound
  cmp ax,[bx]              ; whole word match?
  jz usrcmdfound
  cmp byte[bx],00h         ; an "extended" key?
  jz usrcmdnotext          ; if it was, no match
  cmp al,[bx]              ; low byte match?
  jz usrcmdfound
usrcmdnotext:
  inc bx                   ; nope, try next in list
  inc bx
  jmp usrchkcmds
usrcmdfound:
  pop bx                   ; restore position
  jmp usrstrdun            ; let caller handle extra command
usrcmdnotfound:
  pop bx                   ; restore position
usrokay:                   ; check for "our" commands
  cmp al,00h               ; is it an extended/editing key?
  jnz usrstrascii          ; nope - check "regular" keys
  cmp ax,LEFT              ; check  editing keys
  jnz usnotleft
  cmp bx,00h               ; are we at beginning of string? - ignore
  jz nextkey
  dec bx                   ; else move position left
  jmp nextkey
usnotleft:
  cmp ax,RIGHT
  jnz usnotright
  cmp bp,bx                ; are we at end of string? - ignore
  jz nextkey
  inc bx                   ; else move position right
  jmp nextkey
usnotright:
  cmp ax,HOME
  jnz usnothome
  xor bx,bx                ; position 0
  jmp nextkey
usnothome:
  cmp ax,ENDK
  jnz usrnotendk
  mov bx,bp                ; position is at end of string
  jmp nextkey
usrnotendk:
  cmp ax,INSERT
  jnz usnotins
  xor cx,01D00h            ; toggle cursor size (bit 15 is overwrite mode)
  jmp nextkey
usnotins:
  cmp ax, DEL
  jnz usnotdel
  cmp bx,bp                ; end of string? - ignore
  jnz usrdragleft          ; use the "backspace" code 
  jmp nextkey
usnotdel:
  jmp nextkey              ; an editing key, but not one we want

usrstrascii:               ; check regular ascii keys
  cmp al,BS
  jnz usnotbs
  cmp bx,00h               ; beginning of string? ignore
  jnz usrbsok
  jmp nextkey
usrbsok:
  dec bx                  ; move position back
usrdragleft:              ; entry point for "delete" routine
  dec bp                  ; shorten length
  push bx                 ; save position
usdrag:
  mov al,[si+bx+1]        ; character from "next" position
  mov [si+bx],al          ; goes in "current" position
  inc bx                  ; cook
  cmp al,00h              ; 'til done
  jnz usdrag
  pop bx                  ; restore position
  jmp nextkey
usnotbs:
  cmp al,ENTERK           ; must think we have our string!
  jz usrstrdun            ; else must be a real addition to our string
  cmp bp,bx               ; end of string?
  jnz usrmidstr           ; nope - do middle of string routine
  inc bp                  ; yep - increase length
  cmp di,bp               ; check for overflow (di= max to get)
  jae usrstradd           ; we're ok - add it
overflow:
  dec bp                  ; put length back to safe level
  mov al,BEEPK            ; toot the damn speaker
  call [putcmethod]
  jmp nextkey             ; and ignore the input
usrmidstr:                ; middle of string routine
  test cx,01000h          ; insert mode?
  jnz usrstradd           ; no - just do it
                          ; make a space for our character
  inc bp                  ; bump length
  cmp di,bp               ; check for overflow
  jb overflow             ; beep and ignore
  push ax                 ; save the character
  push bp                 ; save length
  xchg bx,bp              ; swap length, position
usrpushrt:                ; push right from position to end
  mov al,[si+bx-1]        ; character in "previous" position
  mov [si+bx],al          ; goes in "current" position
  dec bx                  ; move back to previous character
  cmp bx,bp               ; 'til we reach the "real" input position
  jnz usrpushrt
  xchg bx,bp              ; swap length,position back
  pop bp                  ; restore the length
  pop ax                  ; restore the character
usrstradd:                ; put a character in our string - finally!
  mov byte[si+bx],al      ; put our character there
  xchg bx,bp
  mov byte[si+bx],00h     ; terminate string (needed if EOS, no harm)
  xchg bx,bp
  inc bx                  ; increase input position
  jmp nextkey             ; get more
usrstrdun:                ; routine terminated by enter or extra cmd
  mov cx,0707h            ; restore "normal" cursor
  call [setcursmethod]
  mov cx,bp               ; return length in cx
  mov di,si               ; beginning of buffer
  add di,cx               ; plus length
  inc di                  ; di points past terminating zero
  pop dx                  ; restore caller's dx
  pop bx                  ;    "       "     bx
  pop bp                  ;    "       "     bp
  ret                     ; if we ain't got it, we ain't gonna
; USRSTR endp
;----------------------------------------------------------------------

;----------------------------------------------------------
; output zero-terminated string pointed to by (ds:)si, via [putcmethod]
; returns - nothing: all registers preserved 
;---------------------------------------------------------
PUTASCZ ; proc
  push ax
  push si
ptz1:
  lodsb
  cmp al,00h
  jz ptz2
  call [putcmethod]
  jmp ptz1
ptz2:
  pop si
  pop ax
  ret
;--------------------------------------------------------------

;-------------------------------------------------
; dos stdout version
CHAROUT
  push dx
  mov dl,al
  mov ah,02h
  int 021h
  pop dx
  ret
; CHAROUT endp
;-------------------------------------------------------

;-------------------------------------------------------
CHK4CHAR
;  xor ax,ax ; XT compatible - doesnt get cntrl-up, etc.
  mov ax,010h ; AT compatible
  int 016h
  ret
; CHK4CHAR endp
;----------------------------------------------------------

;----------------------------------------------------------
SETCURSOR
  push ax
  push bx
  mov ah,01h                     ; set cursor to size in cx
  mov bh,00h                     ; video page zero
  int 010h                       
  mov ah,02h                     ; set cursor position to dx (row:column)
  int 010h
  pop bx
  pop ax
  ret
; SETCURSOR endp
;---------------------------------------------------------

;--------------------------------------------------------
GETCURSOR
  push ax
  push bx
  mov ah,03h                     ; set cursor position,size
  mov bh,00h                     ; video page zero
  int 010h                       ; cursor pos in dx - size in cx
  pop bx
  pop ax
  ret
; GETCURSOR endp
;--------------------------------------------------------------

; ----------------------------------------------------------
; prints a CR/LF pair via [putcmethod]
; ------------------------------------------------------
CRLF ; proc
  push ax
  push dx
  mov al,0dh
  call [putcmethod]
  mov al,0Ah
  call [putcmethod]
  pop dx
  pop ax
  ret
;CRLF endp
; --------------------------end CRLF-----------------------
