; ----------------------------------------------------------------------------
; sseexample.asm
;
; This program demonstrates a few SSE instructions, for no particular reason
; other than to show them off.
; ----------------------------------------------------------------------------

	extern	_printf
	global	_main
	
	section	.text
_main:
	push	esi			; callee save register

; Illustrate packed square root computations	
	movups	xmm3, [x]
	sqrtps	xmm0, xmm3
	movups	[y], xmm0
	call	printall

; Illustrate packed maximums
	movups	xmm2, [x]
	movups	xmm5, [z]
	maxps	xmm2, xmm5
	movups	[y], xmm2
	call	printall

; Done
	pop	esi
	ret

printall:	
	mov	esi, 4
printone:
	; Note printf will NOT ACCEPT single precision floats.
	; We have to convert them to double precision floats. Sigh.
	fld	dword [y-4+esi*4]
	sub	esp, 8
	fstp	qword [esp]
	push	dword format
	call	_printf
	add	esp, 12
	dec	esi
	jnz	printone
	ret
	
	
	section	.data
	align	16
x	dd	10.0
	dd	100.0
	dd	400.0
	dd	653.2664
y	dd	0.0
	dd	0.0
	dd	0.0
	dd	0.0
z	dd	5.0
	dd	900.0
	dd	316.20
	dd	111.0
format	db	'%15.7f', 10, 0


