; ----------------------------------------------------------------------------
; sum.asm
;
; NASM implementation of a function that returns the sum of all the elements
; in a floating-point array.  The function has prototype:
;
;   double sum(double[] array, int length)
; ----------------------------------------------------------------------------	

	global	_sum
	
	section .text
_sum:
	mov	edx, [esp+4]		; address of argument
	mov	ecx, [esp+8]		; length of array
	fldz                            ; initialize the sum to 0
	cmp	ecx, 0			; guard against non-positive lengths!
	jle	done
next:
	fadd	qword [edx]             ; add in the current array element
	add	edx, 8                  ; move to next array element
	dec	ecx                     ; count down
	jnz	next			; if not done counting, continue
done:
	ret              		; return value already in st0
